<?php

namespace App\Modules\Briefing\Application\ListGroupPassenger;

use App\Modules\BookingTour\Domain\BookingTourDateBriefing;
use App\Modules\Group\Domain\IdGroup;
use App\Modules\Briefing\Domain\BriefingOrderBy;
use App\Modules\Briefing\Domain\BriefingRepository;
use App\Modules\Briefing\Domain\BriefingType;
use App\Modules\Briefing\Domain\ListGroupPassengerBriefing;
use App\Modules\Shared\Domain\DateTimeEnd;
use App\Modules\Shared\Domain\DateTimeStart;

final class BriefingGroupPassengerLister
{
    public function __construct(private BriefingRepository $repository)
    {
    }

    public function __invoke(
        DateTimeStart $dateTimeStart,
        DateTimeEnd $dateTimeEnd,
        BriefingType $type,
        BriefingOrderBy $orderBy,
        IdGroup $idGroup,
        BookingTourDateBriefing $dateBriefing,
    )
    {
        return $this->repository->search(new ListGroupPassengerBriefing(
            $dateTimeStart,
            $dateTimeEnd,
            $type,
            $orderBy,
            $idGroup,
            $dateBriefing,
            false
        ));
    }
}
