<?php

namespace App\Modules\BookingUpgradePassenger\Infrastructure;

use App\Modules\Admin\Domain\IdAdmin;
use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;
use App\Modules\BookingUpgradePassenger\Domain\BookingUpgradePassengerFromPassenger;
use App\Modules\BookingUpgradePassenger\Domain\BookingUpgradePassengerAmount;
use App\Modules\BookingUpgradePassenger\Domain\BookingUpgradePassengerCode;
use App\Modules\BookingUpgradePassenger\Domain\BookingUpgradePassengerDate;
use App\Modules\BookingUpgradePassenger\Domain\BookingUpgradePassengerDateEntryEnd;
use App\Modules\BookingUpgradePassenger\Domain\BookingUpgradePassengerDateEntryStart;
use App\Modules\BookingUpgradePassenger\Domain\BookingUpgradePassengerDatePurchase;
use App\Modules\BookingUpgradePassenger\Domain\BookingUpgradePassengerMask;
use App\Modules\BookingUpgradePassenger\Domain\BookingUpgradePassengerRemark;
use App\Modules\BookingUpgradePassenger\Domain\BookingUpgradePassengerRepository;
use App\Modules\BookingUpgradePassenger\Domain\BookingUpgradePassengerStatus;
use App\Modules\BookingUpgradePassenger\Domain\IdBookingUpgradePassenger;
use App\Modules\BookingUpgradePassenger\Domain\ListBookingUpgradePassenger;
use App\Modules\Shared\Application\SelectHandler;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use App\Modules\Shared\Infraestructure\RequestChecker;
use App\Modules\Shared\Infraestructure\Requester;
use Illuminate\Support\Facades\DB;

class MysqlBookingUpgradePassengerRepository implements BookingUpgradePassengerRepository
{

    public function index(IdBookingUpgradePassenger $id): array
    {
        return (new SelectHandler())->handle(DB::select(
            'CALL sp_booking_upgrade_passenger_index(?)',
            [
                $id->value(),
            ]
        ));
    }

    public function search(StorageCriteria $criteria): array
    {
        return array_map(fn($bep) => ListBookingUpgradePassenger::fromDTO($bep), $criteria->run());
    }

    public function reset(IdBookingUpgradePassenger $id)
    {
        return Requester::requestUpdate(
            'CALL sp_booking_upgrade_passenger_reset(?,@sts,@cod,@msg)',
            [$id->value()]
        );
    }

    public function remove(IdBookingUpgradePassenger $id, int $keepInvoice)
    {
        return RequestChecker::requestUpdate(
            'CALL `sp_booking_upgrade_passenger_delete`(?,?,@sts,@cod,@msg)',
            [$id->value(), $keepInvoice]
        );
    }

    public function mask(IdBookingUpgradePassenger $id, BookingUpgradePassengerMask $mask)
    {
        return Requester::requestUpdate(
            'CALL sp_booking_upgrade_passenger_mask(?,?,@sts,@cod,@msg)',
            [$id->value(), $mask->value()]
        );
    }

    public function listByPassenger(IdBookingTourPassenger $idBookingTourPassenger)
    {
        $list = Requester::requestUpdate(
            'CALL sp_booking_upgrade_passenger_list(?,?)',
            [0, $idBookingTourPassenger->value()]
        );
        return array_map([$this, 'convertToBookingUpgradePassenger'], $list['Response_Data']);
    }

    private function convertToBookingUpgradePassenger($dto)
    {
        return new BookingUpgradePassengerFromPassenger(
            new BookingUpgradePassengerDate($dto->BookingUpgradePassenger_Date),
            new BookingUpgradePassengerDateEntryStart($dto->BookingUpgradePassenger_DateEntryStart),
            new BookingUpgradePassengerDateEntryEnd($dto->BookingUpgradePassenger_DateEntryEnd),
            new BookingUpgradePassengerDatePurchase($dto->BookingUpgradePassenger_DatePurchase),
            new BookingUpgradePassengerCode($dto->BookingUpgradePassenger_Code),
            new BookingUpgradePassengerAmount($dto->BookingUpgradePassenger_Amount),
            new BookingUpgradePassengerRemark($dto->BookingUpgradePassenger_Remark),
            new BookingUpgradePassengerStatus($dto->BookingUpgradePassenger_Status),
            new IdAdmin($dto->Id_Admin),
            new IdBookingUpgradePassenger($dto->Id_BookingUpgradePassenger),
        );
    }
}
