<?php

namespace App\Modules\BookingUpgradePassenger\Application\ListByPassenger;

use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ListByPassengerBookingUpgradePassengerQueryHandler implements QueryHandler
{
    public function __construct(private BookingUpgradePassengerPassengerLister $masker)
    {
    }

    public function __invoke(ListByPassengerBookingUpgradePassengerQuery $query): ListByPassengerBookingUpgradePassengerResponse
    {
        return $this->masker->__invoke(
            new IdBookingTourPassenger($query->idBookingTourPassenger())
        );
    }
}
