<?php

namespace App\Modules\BookingTourPassenger\Domain;

use App\Modules\BookingTour\Domain\BookingTourStatus;
use App\Modules\BookingTour\Domain\IdBookingTour;
use App\Modules\HtlCampBookingPassenger\Domain\HtlCampBookingPassengerStatus;
use App\Modules\Passenger\Domain\IdPassenger;

class BookingTourPassenger
{
    public function __construct(
        private IdBookingTourPassenger $id,
        private BookingTourPassengerLock $lock,
        private BookingTourPassengerReportable $reportable,
        private BookingTourPassengerHotel $hotel,
        private BookingTourPassengerRemark $remark,
        private BookingTourPassengerPrice $price,
        private BookingTourPassengerFull $full,
        private BookingTourPassengerValidGroups $validGroups,
        private BookingTourPassengerNoValidGroups $noValidGroups,
        private BookingTourPassengerStatus $status,
        private BookingTourPassengerPaymentStatus $paymentStatus,
        private IdBookingTour $idBookingTour,
        private IdPassenger $idPassenger,
    ) {
    }

    public function id(): IdBookingTourPassenger
    {
        return $this->id;
    }
    public function lock(): BookingTourPassengerLock
    {
        return $this->lock;
    }
    public function reportable(): BookingTourPassengerReportable
    {
        return $this->reportable;
    }
    public function hotel(): BookingTourPassengerHotel
    {
        return $this->hotel;
    }
    public function remark(): BookingTourPassengerRemark
    {
        return $this->remark;
    }
    public function price(): BookingTourPassengerPrice
    {
        return $this->price;
    }
    public function full(): BookingTourPassengerFull
    {
        return $this->full;
    }
    public function validGroups(): BookingTourPassengerValidGroups
    {
        return $this->validGroups;
    }
    public function noValidGroups(): BookingTourPassengerNoValidGroups
    {
        return $this->noValidGroups;
    }
    public function status(): BookingTourPassengerStatus
    {
        return $this->status;
    }
    public function paymentStatus(): BookingTourPassengerPaymentStatus
    {
        return $this->paymentStatus;
    }
    public function idBookingTour(): IdBookingTour
    {
        return $this->idBookingTour;
    }
    public function idPassenger(): IdPassenger
    {
        return $this->idPassenger;
    }

    public static function fromDTO($dto)
    {
        return new BookingTourPassenger(
            new IdBookingTourPassenger($dto->Id_BookingTourPassenger),
            new BookingTourPassengerLock($dto->BookingTourPassenger_Lock),
            new BookingTourPassengerReportable($dto->BookingTourPassenger_Reportable),
            new BookingTourPassengerHotel($dto->BookingTourPassenger_Hotel),
            new BookingTourPassengerRemark($dto->BookingTourPassenger_Remark),
            new BookingTourPassengerPrice($dto->BookingTourPassenger_Price),
            new BookingTourPassengerFull($dto->BookingTourPassenger_Full),
            new BookingTourPassengerValidGroups($dto->BookingTourPassenger_ValidGroups),
            new BookingTourPassengerNoValidGroups($dto->BookingTourPassenger_NoValidGroups),
            new BookingTourPassengerStatus($dto->BookingTourPassenger_Status),
            new BookingTourPassengerPaymentStatus($dto->BookingTourPassenger_PaymentStatus),
            new IdBookingTour($dto->Id_BookingTour),
            new IdPassenger($dto->Id_Passenger)
        );
    }

    public function remove()
    {
        $this->status = new BookingTourPassengerStatus(BookingTourPassengerStatus::CANCELLED);
    }

    public static function isInCalendar($booking, $bookingTourPassenger)
    {
        return ($booking->Booking_Status == 1 || $booking->Booking_Status == 2)
            && (
                $booking->Booking_ManuallyConfirmed == 2
                ? 1
                : $bookingTourPassenger->BookingTourPassenger_PaymentStatus == 2
            )
            && (
                $bookingTourPassenger->BookingTourPassenger_Status == 2
                || $bookingTourPassenger->BookingTourPassenger_Status == 3
            );
    }

    public static function isPending($booking, $bookingTourPassenger)
    {
        return ($booking->Booking_Status == 1 || $booking->Booking_Status == 2)
            && (
                $bookingTourPassenger->BookingTourPassenger_Status == 2
                || $bookingTourPassenger->BookingTourPassenger_Status == 3
            );
    }

    public static function htlCampBookingPassengerStatus($isInCalendar, $isPending)
    {
        return $isInCalendar
            ? HtlCampBookingPassengerStatus::ACTIVE
            : (
                $isPending
                ? HtlCampBookingPassengerStatus::INACTIVE
                : HtlCampBookingPassengerStatus::DELETED
            );
    }

    public static function genHtlCampBookingPassengerStatus($booking, $bookingTourPassenger)
    {
        $isInCalendar = BookingTourPassenger::isInCalendar($booking, $bookingTourPassenger);
        $isPending = BookingTourPassenger::isPending($booking, $bookingTourPassenger);
        return BookingTourPassenger::htlCampBookingPassengerStatus($isInCalendar, $isPending);
    }
}
