<?php

namespace App\Modules\BookingTourPassenger\Application\ListByCashMovement;

use App\Modules\BookingTourPassenger\Domain\BookingTourPassengerRepository;
use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;
use App\Modules\CashMovement\Domain\IdCashMovement;

final class BookingTourPassengerByCashMovementLister
{
    public function __construct(
        private BookingTourPassengerRepository $repository
    ) {
    }

    public function __invoke(
        IdCashMovement $id,
        string $action
    ): ListByCashMovementBookingTourPassengerResponse {
        return new ListByCashMovementBookingTourPassengerResponse($this->repository->listByCashMovement($id, $action));
    }
}
