<?php

namespace App\Modules\BookingTourPassenger\Application\Find;

use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class FindBookingTourPassengerQueryHandler implements QueryHandler
{
    public function __construct(private BookingTourPassengerFinder $changer)
    {
    }

    public function __invoke(FindBookingTourPassengerQuery $query): FindBookingTourPassengerResponse
    {
        return $this->changer->__invoke(
            new IdBookingTourPassenger($query->id())
        );
    }
}
