<?php

namespace App\Modules\BookingTourPassenger\Application\Activate;

use App\Modules\BookingTourPassenger\Domain\BookingTourPassengerRepository;
use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;

final class BookingTourPassengerActivator
{
    public function __construct(
        private BookingTourPassengerRepository $repository
    ) {
    }

    public function __invoke(
        IdBookingTourPassenger $id,
    ): ActivateBookingTourPassengerResponse {
        return new ActivateBookingTourPassengerResponse($this->repository->cancel($id));
    }
}
