<?php

namespace App\Modules\BookingTour\Domain;

use Illuminate\Support\Facades\DB;

class IndexBookingTour
{

    public function __construct(
        private IdBookingTour $id
    ) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        return DB::select(
            'SELECT `Id_BookingTour`,
                    `BookingTour_DateStart`,
                    `BookingTour_PickUp`,
                    `BookingTour_Type`,
                    `BookingTour_NoPax`,
                    `BookingTour_Name`,
                    `BookingTour_TourName`,
                    `BookingTour_FeeType`,
                    `BookingTour_Full`,
                    `BookingTour_MinimumFull`,
                    `BookingTour_Group`,
                    `BookingTour_TourDuration`,
                    `BookingTour_Status`,
                    `Id_Booking`,
                    `Id_Package`,
                    `Id_Tour`
            FROM `t_booking_tour`
            WHERE `Id_BookingTour` = ?',
            [
                $this->id->value()
            ]
        );
    }

    protected function analize($data)
    {
        if (!count($data)) {
            throw new BookingTourNotFound();
        }
        return $data[0];
    }
}
