<?php

namespace App\Modules\BookingExtraPassenger\Infrastructure;

use App\Modules\BookingExtraPassenger\Domain\BookingExtraPassengerMask;
use App\Modules\BookingExtraPassenger\Domain\BookingExtraPassengerRepository;
use App\Modules\BookingExtraPassenger\Domain\IdBookingExtraPassenger;
use App\Modules\BookingExtraPassenger\Domain\ListBookingExtraPassenger;
use App\Modules\Shared\Application\SelectHandler;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use App\Modules\Shared\Infraestructure\Requester;
use Illuminate\Support\Facades\DB;

class MysqlBookingExtraPassengerRepository implements BookingExtraPassengerRepository
{

    public function index(IdBookingExtraPassenger $id): array
    {
        return (new SelectHandler())->handle(DB::select(
            'CALL sp_booking_extra_passenger_index(?)',
            [
                $id->value(),
            ]
        ));
    }

    public function search(StorageCriteria $criteria): array
    {
        return array_map(fn($bep) => ListBookingExtraPassenger::fromDTO($bep), $criteria->run());
    }

    public function reset(IdBookingExtraPassenger $id)
    {
        return Requester::requestUpdate(
            'CALL sp_booking_extra_passenger_reset(?,@sts,@cod,@msg)',
            [$id->value()]
        );
    }

    public function mask(IdBookingExtraPassenger $id, BookingExtraPassengerMask $mask)
    {
        return Requester::requestUpdate(
            'CALL sp_booking_extra_passenger_mask(?,?,@sts,@cod,@msg)',
            [$id->value(), $mask->value()]
        );
    }
}
