<?php

namespace App\Modules\BookingExtraPassenger\Domain;

use App\Modules\Admin\Domain\IdAdmin;
use App\Modules\Booking\Domain\BookingCode;
use App\Modules\Booking\Domain\BookingInternalRemark;
use App\Modules\Booking\Domain\BookingObservation;
use App\Modules\Booking\Domain\IdBooking;
use App\Modules\BookingExtra\Domain\IdBookingExtra;
use App\Modules\BookingTour\Domain\BookingTourDateEnd;
use App\Modules\BookingTour\Domain\BookingTourDateStart;
use App\Modules\BookingTour\Domain\BookingTourTourDuration;
use App\Modules\BookingTour\Domain\BookingTourTourName;
use App\Modules\BookingTour\Domain\IdBookingTour;
use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;
use App\Modules\Passenger\Domain\IdPassenger;
use App\Modules\Passenger\Domain\PassengerGender;
use App\Modules\Passenger\Domain\PassengerLastName;
use App\Modules\Passenger\Domain\PassengerName;
use App\Modules\Shared\Domain\Aggregate\AggregateAttribute;
use App\Modules\Shared\Domain\Aggregate\AggregateRoot;
use App\Modules\UserCountry\Domain\IdUserCountry;
use App\Modules\UserCountry\Domain\UserCountryImg;
use App\Modules\UserCountry\Domain\UserCountryName;

class ListBookingExtraPassenger extends AggregateRoot
{

    /** @return AgregateAttribute[] */
    protected static function attributes(): array
    {
        return [
            new AggregateAttribute('id', IdBookingExtraPassenger::class, 'Id_BookingExtraPassenger'),
            new AggregateAttribute('date', BookingExtraPassengerDate::class, 'BookingExtraPassenger_Date'),
            new AggregateAttribute('dateEntryStart', BookingExtraPassengerDateEntryStart::class, 'BookingExtraPassenger_DateEntryStart'),
            new AggregateAttribute('dateEntryEnd', BookingExtraPassengerDateEntryEnd::class, 'BookingExtraPassenger_DateEntryEnd'),
            new AggregateAttribute('datePurchase', BookingExtraPassengerDatePurchase::class, 'BookingExtraPassenger_DatePurchase'),
            new AggregateAttribute('code', BookingExtraPassengerCode::class, 'BookingExtraPassenger_Code'),
            new AggregateAttribute('amount', BookingExtraPassengerAmount::class, 'BookingExtraPassenger_Amount'),
            new AggregateAttribute('remark', BookingExtraPassengerRemark::class, 'BookingExtraPassenger_Remark'),
            new AggregateAttribute('status', BookingExtraPassengerStatus::class, 'BookingExtraPassenger_Status'),
            new AggregateAttribute('idAdmin', IdAdmin::class, 'Id_Admin'),
            new AggregateAttribute('idBookingExtra', IdBookingExtra::class, 'Id_BookingExtra'),
            new AggregateAttribute('idBookingTourPassenger', IdBookingTourPassenger::class, 'Id_BookingTourPassenger'),
            new AggregateAttribute('idPassenger', IdPassenger::class, 'Id_Passenger'),
            new AggregateAttribute('passengerGender', PassengerGender::class, 'Passenger_Gender'),
            new AggregateAttribute('passengerName', PassengerName::class, 'Passenger_Name'),
            new AggregateAttribute('passengerLastName', PassengerLastName::class, 'Passenger_LastName'),
            new AggregateAttribute('idBookingTour', IdBookingTour::class, 'Id_BookingTour'),
            new AggregateAttribute('bookingTourTourName', BookingTourTourName::class, 'BookingTour_TourName'),
            new AggregateAttribute('bookingTourDateStart', BookingTourDateStart::class, 'BookingTour_DateStart'),
            new AggregateAttribute('bookingTourTourDuration', BookingTourTourDuration::class, 'BookingTour_TourDuration'),
            new AggregateAttribute('idBooking', IdBooking::class, 'Id_Booking'),
            new AggregateAttribute('bookingCode', BookingCode::class, 'Booking_Code'),
            new AggregateAttribute('bookingInternalRemark', BookingInternalRemark::class, 'Booking_InternalRemark'),
            new AggregateAttribute('bookingObservation', BookingObservation::class, 'Booking_Observation'),
            new AggregateAttribute('idUserCountry', IdUserCountry::class, 'Id_UserCountry'),
            new AggregateAttribute('userCountryName', UserCountryName::class, 'UserCountry_Name'),
            new AggregateAttribute('userCountryImg', UserCountryImg::class, 'UserCountry_Img'),
        ];
    }

    public function __construct(
        private IdBookingExtraPassenger $id,
        private BookingExtraPassengerDate $date,
        private BookingExtraPassengerDateEntryStart $dateEntryStart,
        private BookingExtraPassengerDateEntryEnd $dateEntryEnd,
        private BookingExtraPassengerDatePurchase $datePurchase,
        private BookingExtraPassengerCode $code,
        private BookingExtraPassengerAmount $amount,
        private BookingExtraPassengerRemark $remark,
        private BookingExtraPassengerStatus $status,
        private IdAdmin $idAdmin,
        private IdBookingExtra $idBookingExtra,
        private IdBookingTourPassenger $idBookingTourPassenger,

        private IdPassenger $idPassenger,
        private PassengerGender $passengerGender,
        private PassengerName $passengerName,
        private PassengerLastName $passengerLastName,
        private IdBookingTour $idBookingTour,
        private BookingTourTourName $bookingTourTourName,
        private BookingTourDateStart $bookingTourDateStart,
        private BookingTourTourDuration $bookingTourTourDuration,
        private IdBooking $idBooking,
        private BookingCode $bookingCode,
        private BookingInternalRemark $bookingInternalRemark,
        private BookingObservation $bookingObservation,
        private IdUserCountry $idUserCountry,
        private UserCountryName $userCountryName,
        private UserCountryImg $userCountryImg,
    ) {
    }

    public function date(): BookingExtraPassengerDate
    {
        return $this->date;
    }
    public function dateEntryStart(): BookingExtraPassengerDateEntryStart
    {
        return $this->dateEntryStart;
    }
    public function dateEntryEnd(): BookingExtraPassengerDateEntryEnd
    {
        return $this->dateEntryEnd;
    }
    public function datePurchase(): BookingExtraPassengerDatePurchase
    {
        return $this->datePurchase;
    }
    public function code(): BookingExtraPassengerCode
    {
        return $this->code;
    }
    public function amount(): BookingExtraPassengerAmount
    {
        return $this->amount;
    }
    public function remark(): BookingExtraPassengerRemark
    {
        return $this->remark;
    }
    public function status(): BookingExtraPassengerStatus
    {
        return $this->status;
    }
    public function idAdmin(): IdAdmin
    {
        return $this->idAdmin;
    }
    public function idBookingExtra(): IdBookingExtra
    {
        return $this->idBookingExtra;
    }
    public function idBookingTourPassenger(): IdBookingTourPassenger
    {
        return $this->idBookingTourPassenger;
    }
    public function id(): IdBookingExtraPassenger
    {
        return $this->id;
    }

    public function idPassenger(): IdPassenger
    {
        return $this->idPassenger;
    }

    public function passengerGender(): PassengerGender
    {
        return $this->passengerGender;
    }

    public function passengerName(): PassengerName
    {
        return $this->passengerName;
    }

    public function passengerLastName(): PassengerLastName
    {
        return $this->passengerLastName;
    }

    public function idBookingTour(): IdBookingTour
    {
        return $this->idBookingTour;
    }
    public function bookingTourTourName(): BookingTourTourName
    {
        return $this->bookingTourTourName;
    }
    public function bookingTourDateStart(): BookingTourDateStart
    {
        return $this->bookingTourDateStart;
    }
    public function bookingTourTourDuration(): BookingTourTourDuration
    {
        return $this->bookingTourTourDuration;
    }
    public function idBooking(): IdBooking
    {
        return $this->idBooking;
    }
    public function bookingCode(): BookingCode
    {
        return $this->bookingCode;
    }
    public function bookingInternalRemark(): BookingInternalRemark
    {
        return $this->bookingInternalRemark;
    }
    public function bookingObservation(): BookingObservation
    {
        return $this->bookingObservation;
    }
    public function idUserCountry(): IdUserCountry
    {
        return $this->idUserCountry;
    }
    public function userCountryName(): UserCountryName
    {
        return $this->userCountryName;
    }
    public function userCountryImg(): UserCountryImg
    {
        return $this->userCountryImg;
    }
}
