<?php

namespace App\Modules\BookingExtraPassenger\Application\Index;

use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class IndexBookingExtraPassengerQueryHandler implements QueryHandler
{
    public function __construct(private BookingExtraPassengerIndexer $lister)
    {
    }

    public function __invoke(IndexBookingExtraPassengerQuery $query): IndexBookingExtraPassengerResponse
    {
        return new IndexBookingExtraPassengerResponse($this->lister->__invoke($query->id()));
    }
}
