<?php

namespace App\Modules\BookingCalendar\Application\List;

use App\Modules\CategoryTour\Domain\IdCategoryTour;
use App\Modules\Package\Domain\IdPackage;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;
use App\Modules\Tour\Domain\IdTour;
use App\Modules\TypeTour\Domain\IdTypeTour;

final class ListBookingCalendarQueryHandler implements QueryHandler
{
    public function __construct(private BookingCalendarLister $lister)
    {
    }

    public function __invoke(ListBookingCalendarQuery $query): ListBookingCalendarResponse
    {
        return $this->lister->__invoke(
            new IdCategoryTour($query->idCategoryTour()),
            new IdTypeTour($query->idTypeTour()),
            new IdTour($query->idTour()),
            new IdPackage($query->idPackage()),
            new DateStart($query->dateStart()),
            new DateEnd($query->dateEnd()),
            $query->token()
        );
    }
}
