<?php

namespace App\Modules\BookingAssign\Application\Update;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class UpdateBookingAssignQuery implements Query
{
    public function __construct(
        private int $id,
        private string $remark,
        private int $status,
    ) {
    }

    public function id(): string
    {
        return $this->id;
    }

    public function remark(): string
    {
        return $this->remark;
    }

    public function status(): int
    {
        return $this->status;
    }
}
