<?php

namespace App\Modules\BookingAdditional\Infrastructure;

use App\Modules\BookingAdditional\Domain\BookingAdditional;
use App\Modules\BookingAdditional\Domain\BookingAdditionalRepository;
use App\Modules\BookingAdditional\Domain\BookingAdditionalType;
use App\Modules\BookingAdditional\Domain\Id;
use App\Modules\BookingAdditional\Domain\IdBookingAdditional;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlBookingAdditionalRepository implements BookingAdditionalRepository
{

    public function find(StorageCriteria $criteria): BookingAdditional | null
    {
        $data = $criteria->run();
        if ($data === null) {
            return null;
        }
        return BookingAdditional::fromDTO($criteria->run());
    }

    public function search(StorageCriteria $criteria): array
    {
        return array_map(fn($btp) => BookingAdditional::fromDTO($btp), $criteria->run());
    }

    public function insert(BookingAdditional $value)
    {
        return Requester::requestInsert(
            'CALL sp_booking_additional_insert(?,?,?,?,?,?,@sts,@cod,@msg,@id)',
            [
                $value->name()->value(),
                $value->abrv()->value(),
                $value->type()->value(),
                $value->status()->value(),
                $value->idBookingTourPassenger()->value(),
                $value->idInternal()->value(),
            ]
        );
    }

    public function update(BookingAdditional $value)
    {
        return Requester::requestUpdate(
            'CALL sp_booking_additional_update(?,?,?,?,?,?,?,@sts,@cod,@msg)',
            [
                $value->id()->value(),
                $value->name()->value(),
                $value->abrv()->value(),
                $value->type()->value(),
                $value->status()->value(),
                $value->idBookingTourPassenger()->value(),
                $value->idInternal()->value(),
            ]
        );
    }

    public function delete(IdBookingAdditional $id)
    {
        return Requester::requestUpdate(
            'CALL sp_booking_additional_delete(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }

    public function deleteFrom(BookingAdditionalType $type, Id $idInternal)
    {
        return Requester::requestUpdate(
            'CALL sp_booking_additional_delete_from(?,?,@sts,@cod,@msg)',
            [
                $type->value(),
                $idInternal->value(),
            ]
        );
    }
}
