<?php

namespace App\Modules\BookingAdditional\Domain;

use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

class ListBookingAdditional implements StorageCriteria
{

    public function __construct(
        private IdBookingTourPassenger $idBookingTourPassenger,
        private string $action
    ) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = BookingAdditional::select('`ftd`');
        if ($this->action == 'all') {
            $where = '`ftd`.`BookingAdditional_Status` IN (1, 2)';
        } else if ($this->action == 'active') {
            $where = '`ftd`.`BookingAdditional_Status` = 2';
        } else if ($this->action == 'deleted') {
            $where = '`ftd`.`BookingAdditional_Status` = 0';
        } else {
            $where = '`ftd`.`BookingAdditional_Status` = 2';
        }
        return DB::select(
            "SELECT $select
            FROM `t_booking_additional` `ftd`
            WHERE $where
            AND `ftd`.`Id_BookingTourPassenger` = ?",
            [$this->idBookingTourPassenger->value()]
        );
    }

    protected function analize($data)
    {
        return $data;
    }
}
