<?php

namespace App\Modules\BookingAdditional\Domain;

use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

class IndexBookingAdditional implements StorageCriteria
{

    public function __construct(
        private IdBookingAdditional $id
    ) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = BookingAdditional::select('`cmfr`');
        
        return DB::select(
            "SELECT $select
            FROM `t_cash_movement_fact_receipt` `cmfr`
            WHERE `cmfr`.`Id_BookingAdditional` = ?",
            [
                $this->id->value()
            ]
        );
    }

    protected function analize($data)
    {
        if (!count($data)) {
            throw new BookingAdditionalNotFound();
        }
        return $data[0];
    }
}
