<?php

namespace App\Modules\BookingAdditional\Application\Delete;

use App\Modules\BookingAdditional\Domain\BookingAdditionalType;
use App\Modules\BookingAdditional\Domain\Id;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class DeleteBookingAdditionalQueryHandler implements QueryHandler
{
    public function __construct(private BookingAdditionalDeleter $creator)
    {
    }

    public function __invoke(DeleteBookingAdditionalQuery $query): DeleteBookingAdditionalResponse
    {
        return $this->creator->__invoke(new BookingAdditionalType($query->type()), new Id($query->idInternal()));
    }
}
