<?php

namespace App\Modules\Booking\Infraestructure;

class BookingValidators
{
    public const INSERT = [
        'Id_User'               => 'int',
        'User_Name'             => 'required|string|max:100',
        'User_LastName'         => 'required|string|max:100',
        'User_Email'            => 'required|string|max:250',
        'User_Phone'            => 'string|max:20',
        'Id_UserCountry'        => 'required|int',
        'Booking'               => 'required|string',
        'CashMovement'          => 'required|string'
    ];

    public const EXPORT_TO_EXCEL = [
        'Booking_Status'    => 'required|int',
        'DateStart'         => 'required|string|date',
        'DateEnd'           => 'required|string|date',
        'Query'             => 'string|max:250',
        'User_Type'         => 'required|int',
        'Booking_Type'      => 'required|int'
    ];
    
    public const UPDATE = [
        'Id_Booking'                => 'required|int',
        'Booking_DateBriefing'      => 'required|string',
        'Booking_PlaceBriefing'     => 'string',
        'Booking_Hotel'             => 'string',
        'Booking_Observation'       => 'string',
        'Booking_Type'              => 'required|int',
        'Booking_InPerson'          => 'required|int',
        'Id_Language'               => 'required|int',
        'Id_GuideLanguage'          => 'required|int',
        'Id_BookingRelationship'    => 'required|int',
        'Id_BookingReferredFrom'    => 'required|int'
    ];
    
    public const UPDATE_MANUALLY_CONFIRMED = [
        'Id_Booking'                => 'required|int',
        'Booking_ManuallyConfirmed' => 'required|int'
    ];

    public const SEARCH_DATE = [
        'Date_Start'        => 'required|string',
        'Date_End'          => 'required|string',
        'Booking_Status'    => 'required|int'
    ];

    public const SEARCH_BOOKING = [
        'Booking_Code'    => 'required|string|max:100'
    ];

    public const SEARCH_CONFIRM = [
        'Date_Start'        => 'required|string',
        'Date_End'          => 'required|string',
        'Order_By'          => 'required|string'
    ];

    public const SEARCH_CONFIRM_EXCEL = [
        'Date_Start'        => 'required|string',
        'Date_End'          => 'required|string',
        'Order_By'          => 'required|string',
        'User_Type'         => 'required|int',
        'Search'            => 'string'
    ];

    public const LIST = [
        'Id_User'           => 'required|int',
        'Date_Start'        => 'required|string|date',
        'Date_End'          => 'required|string|date',
        'Booking_Status'    => 'required|int'
    ];

    public const REPORT = [
        'Name'              => 'required|string|max:100'
    ];
}
