<?php

namespace App\Modules\Booking\Domain;

use App\Modules\User\Domain\UserEmail;
use App\Modules\User\Domain\UserLastName;
use App\Modules\User\Domain\UserName;
use App\Modules\User\Domain\UserPhone;
use App\Modules\User\Domain\UserPhoneCode;
use App\Modules\User\Domain\UserStatus;

/** Encapsula los datos a exportar en excel del booking */
class ReportUser {

    private UserName $userName;
    private UserLastName $userLastName;
    private UserEmail $userEmail;
    private UserPhone $userPhone;
    private UserPhoneCode $userPhoneCode;
    private UserStatus $userStatus;
    

    /** constructor */
    public function __construct (
        UserName $userName,
        UserLastName $userLastName,
        UserEmail $userEmail,
        UserPhone $userPhone,
        UserPhoneCode $userPhoneCode,
        UserStatus $userStatus
    ) {
        
        $this->userName = $userName;
        $this->userLastName = $userLastName;
        $this->userEmail = $userEmail;
        $this->userPhone = $userPhone;
        $this->userPhoneCode = $userPhoneCode;
        $this->userStatus = $userStatus;
    }

    public function getName():UserName { return $this->userName; }
    public function getLastName():UserLastName { return $this->userLastName; }
    public function getEmail():UserEmail { return $this->userEmail; }
    public function getPhone():UserPhone { return $this->userPhone; }
    public function getPhoneCode():UserPhoneCode { return $this->userPhoneCode; }
    public function getStatus():UserStatus { return $this->userStatus; }
}