<?php

namespace App\Modules\Booking\Application\Report\SalesByPackage;

use Illuminate\Support\Facades\DB;

final class BookingSalesByMonthReporter
{
    public function __construct()
    {
    }

    public function __invoke($dateStart, $dateEnd)
    {
        $orderBy = '`b`.`Booking_DateConfirm`';
        // $orderBy = '`b`.`Booking_DateStart`';
        return DB::select(
            "SELECT
                DATE_FORMAT(`aux`.`Booking_MonthStart`, '%Y-%m') AS `Month`,
                COUNT(DISTINCT `Id_Booking`) AS `Amount`
            FROM (
                SELECT  `b`.`Id_Booking`,
                        `ps`.`Id_Passenger`,
                        `b`.`Booking_DateConfirm`,
                        `b`.`Booking_DateStart`,
                        DATE_FORMAT($orderBy, '%Y-%m-01') AS `Booking_MonthStart`
                FROM `t_booking` `b`
                INNER JOIN `t_passenger` `ps` ON `ps`.`Id_Booking` = `b`.`Id_Booking`
                INNER JOIN `t_booking_tour` `bt` ON `bt`.`Id_Booking` = `b`.`Id_Booking`
                WHERE $orderBy BETWEEN ? AND DATE_SUB(?, INTERVAL 1 DAY)
                AND   `b`.`Booking_Status` IN (2, 3)
                AND   `ps`.`Passenger_Status` = 2
                AND   `bt`.`Id_Package` = 1
            ) `aux`
            GROUP BY `aux`.`Booking_MonthStart`
            ORDER BY `aux`.`Booking_MonthStart`",
            [$dateStart, $dateEnd]
        );
        // dd($data);
    }
}
