<?php

namespace App\Modules\Booking\Application\Find;

use App\Modules\Booking\Domain\BookingRepository;
use App\Modules\Booking\Domain\IdBooking;
use App\Modules\Booking\Domain\IndexBooking;

class BookingFinder
{
    public function __construct(
        private BookingRepository $bookingRepository
    ) {}

    public function __invoke(IdBooking $id)
    {
        return $this->bookingRepository->find(new IndexBooking($id));
    }
}
