<?php

namespace App\Modules\Batch\Application\Run;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class RunBatchQuery implements Query
{
    public function __construct(
        private array $batch,
        private string $token,
        private string $url,
        private string $ip
    ) {
    }

    public function batch(): array
    {
        return $this->batch;
    }

    public function token(): string
    {
        return $this->token;
    }

    public function url(): string
    {
        return $this->url;
    }

    public function ip(): string
    {
        return $this->ip;
    }
}
