<?php

namespace App\Http\Controllers\Passenger;

use App\Http\Controllers\Controller;
use DB;
use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use App\Modules\Group\Application\GroupTokenFinder;
use App\Modules\Group\Application\PassengerGroupIndexer;
use App\Modules\Group\Domain\GroupToken;
use App\Modules\Group\Infraestructure\GroupValidators;
use App\Modules\Group\Infraestructure\MysqlGroupFindByTokenRepository;
use App\Modules\Group\Infraestructure\MysqlGroupRepository;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;

class c_Group extends Controller
{
    private $oDomain;

    public function __construct()
    {
        $this->oDomain = "Group";
    }

    public function IndexByGroupToken(Request $Request)
    {
        (new LaravelValidator)->validate($Request->all(), $this->oDomain, GroupValidators::GROUP_TOKEN_INDEX);

        $oResponse = (new PassengerGroupIndexer(new MysqlGroupRepository))->__invoke(
            new GroupToken($Request->input('Group_Token')),
            new GroupTokenFinder(new MysqlGroupFindByTokenRepository)
        );
        return ResponseBuilder::Response($oResponse);
    }
}
