<?php

namespace App\Http\Controllers\Passenger\PassengerReview;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\GroupPassenger\Domain\IdGroupPassenger;
use App\Modules\GroupPassengerReview\Application\List\GroupPassengerReviewListerResponse;
use App\Modules\PassengerReview\Application\PassengerReviewFinderByGroupPassenger;
use App\Modules\PassengerReview\Infraestructure\MysqlPassengerReviewRepository;
use App\Modules\PassengerReview\Infraestructure\PassengerReviewValidators;
use App\Modules\Shared\Application\SelectHandler;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class PassengerReviewIndexController
{
    private $oDomain;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->oDomain = "Passenger Review";
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator)->validate($request->all(), $this->oDomain, PassengerReviewValidators::GROUP_PASSENGER);
        $groupPassenger = $this->getGroupPassenger($request->Id_GroupPassenger);
        $passenger = $this->getPassenger($groupPassenger[0]->Id_Passenger);
        /** @var GroupPassengerReviewListerResponse response */
        $response = $this->getGroupPassengerReview($request->Id_GroupPassenger);
        $response['Response_Data'] = [
            'Passenger' => $passenger[0],
            'Group' => $groupPassenger[0],
            'Review' => $response['Response_Data']
        ];
        return ResponseBuilder::Response($response);
    }

    private function getGroupPassenger($idGroupPassenger)
    {
        $param = [
            $idGroupPassenger,
            config('var.PATH_PUBLIC') . config('var.USER_COUNTRY_THUMB')
        ];
        return (new SelectHandler())->handle(DB::select('CALL sp_group_passenger_index(?, ?)', $param));
    }

    private function getPassenger($idPassenger)
    {
        $params = [
            $idPassenger,
            config("var.PATH_PUBLIC") . config("var.PASSENGER_IMGDOCUMENT1_THUMB"),
            config("var.PATH_PUBLIC") . config("var.PASSENGER_IMGDOCUMENT1_LARGE"),
            config("var.PATH_PUBLIC") . config("var.PASSENGER_IMGDOCUMENT2_THUMB"),
            config("var.PATH_PUBLIC") . config("var.PASSENGER_IMGDOCUMENT2_LARGE"),
        ];
        return DB::select('CALL sp_passenger_index(?,?,?,?,?)', $params);
    }

    private function getGroupPassengerReview($idGroupPassenger)
    {

        return (new PassengerReviewFinderByGroupPassenger(new MysqlPassengerReviewRepository))
            ->__invoke(
                new IdGroupPassenger($idGroupPassenger)
            );
    }
}
