<?php

namespace App\Http\Controllers\Passenger\GroupProviderReview;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\GroupProviderReview\Application\List\GroupProviderReviewListerQuery;
use App\Modules\GroupProviderReview\Application\List\GroupProviderReviewListerResponse;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Infraestructure\Requester;
use Illuminate\Support\Facades\DB;

class GroupProviderReviewListController
{
    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($idGroupProvider)
    {
        $groupProvider = $this->getGroupProvider($idGroupProvider)['Response_Data'];
        $provider = $this->getProvider($groupProvider[0]->Id_Provider);
        /** @var GroupProviderReviewListerResponse response */
        $response = $this->getGroupProviderReview($idGroupProvider);
        $response = $response->response();
        $response['Response_Data'] = [
            'Provider' => $provider[0],
            'Group' => $groupProvider[0],
            'Review' => $response['Response_Data']
        ];
        return ResponseBuilder::Response($response);
    }

    private function getGroupProvider($idGroupProvider)
    {
        return Requester::requestSelect(
            'CALL sp_passenger_group_provider_index_by_review(?, @sts, @cod, @msg)',
            [ $idGroupProvider ]
        );
    }

    private function getProvider($idProvider)
    {
        return DB::select('CALL sp_provider_index(?)', [ $idProvider ]);
    }

    private function getGroupProviderReview($idGroupProvider)
    {
        return $this->queryBus->ask(new GroupProviderReviewListerQuery($idGroupProvider, 'active'));
    }
}
