<?php
namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use Illuminate\Support\Str;

use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use Illuminate\Support\Facades\DB;

class c_Type_Document_Transl extends Controller
{
    private $oDomain;
    /** @var HistoryData */
    private $history;

    public function __construct()
    {
        $this->oDomain = "Type Document Translate";
        $this->history = new HistoryData(HistoryTables::type_document_transl);
    }

    public function Insert(Request $Request)
    {
        $oResponse  = array();
        $oValParams = [
            'TypeDocumentTransl_Title'      => 'required|string|max:250',
            'Id_TypeDocument'               => 'required|int',
            'Id_Language'                   => 'required|int'
        ];


        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $oParam = array(
                trim($Request->input("TypeDocumentTransl_Title")),
                $Request->input("Id_TypeDocument"),
                $Request->input("Id_Language"),
                1
            );
            $oData = DB::select('call sp_type_document_transl_insert(?,?,?,?)', $oParam);

            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                $this->history->insertBasic($Request);
            } else {
            }
            
            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
        
    }
    public function Update(Request $Request)
    {
        $oResponse  = array();
        $oValParams = [
            'Id_TypeDocumentTransl'         => 'required|int',
            'TypeDocumentTransl_Title'      => 'required|string|max:250',
            'Id_TypeDocument'               => 'required|int',
            'Id_Language'                   => 'required|int'
        ];
        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $this->history->obtainOld($Request->input('Id_TypeDocumentTransl'));

            $oParam = array(
                $Request->input("Id_TypeDocumentTransl"),
                trim($Request->input("TypeDocumentTransl_Title")),
                $Request->input("Id_TypeDocument"),
                $Request->input("Id_Language")
            );
            $oData = DB::select('call sp_type_document_transl_update(?,?,?,?)', $oParam);

            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                $this->history->updateBasic($Request->input("Id_TypeDocumentTransl"), $Request);
            } else {
            }
            
            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);

    }
    public function Delete(Request $Request, $Id)
    {
        $oResponse  = array();

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Id($Id, $this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $this->history->obtainOld($Id);

            $oParam = array( $Id );
            $oData  = DB::select('call sp_type_document_transl_delete(?)', $oParam);

            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                $this->history->deleteBasic($Id, $Request);
            } else {
                
            }
            
            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }
    public function Index(Request $Request, $Id)
    {
        $oResponse  = array();

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Id($Id, $this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {       
            $oParam = array( $Id );
            $oData  = DB::select('call sp_type_document_transl_index(?)', $oParam);
            
            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain." Index";
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }
    public function List(Request $Request, $Id_TypeDocument)
    {
        $oResponse  = array();

        $oResponse = ParamsValidator::Validate_Id($Id_TypeDocument, $this->oDomain);

        if ($oResponse["Response_Code"] == 200) {
            $oParam = array( $Id_TypeDocument );
            $oData  = DB::select('call sp_type_document_transl_list(?)', $oParam);

            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain." list";
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }

        
}