<?php
namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;

use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use Intervention\Image\ImageManagerStatic as Image;
use App\Providers\ExcelRegistryReport\ExcelRegistryReport;

class c_Registry extends Controller
{
	private $oDomain;
	/** @var HistoryData */
	private $history;

	public function __construct()
	{
		$this->oDomain = "Registry";
		$this->history = new HistoryData (HistoryTables::registry);
	}

	public function Insert(Request $Request){
		
		$oResponse  = array();
		$oValParams = array(    'Registry_DocumentSerie'	=> 'required|string',
								'Registry_DocumentNumber'	=> 'required|string',
								'Registry_Type'				=> 'required|int',
                                'Id_Provider'				=> 'required|int',
								'Id_Warehouse'				=> 'required|int',
								'Id_Group'					=> 'required|int',
								'Id_RegistryConfiguration'	=> 'required|int'
							);


		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {			
            $oParam = array(    $Request->input("Registry_DocumentSerie"),
								$Request->input("Registry_DocumentNumber"),
								$Request->input("Registry_Type"),
								$Request->input("Id_Provider"),
								$Request->input("Id_Warehouse"),
								$Request->input("Id_Group"),
								$Request->input("Id_RegistryConfiguration"),
								$Request->header('Token'),
								''
							);
			$oData = DB::select('call sp_registry_insert(?,?,?,?,?,?,?,?,?)',$oParam);

			//  RESPONSE
			if ($oData[0]->Response_Success == 1) {
				//region HISTORY EXEC
				$this->history->insertBasic ($Request);
				//endregion
			} else { }
			
			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}
		return ResponseBuilder::Response($oResponse);
	}

	public function Update(Request $Request){
		$oResponse  = array();
		$oValParams = array(    'Id_Registry'				=> 'required|int',
								'Registry_DocumentDate'		=> 'required|string',
								'Registry_DocumentSerie'	=> 'required|string',
								'Registry_DocumentNumber'	=> 'required|string',
								'Id_Provider'				=> 'required|int',
								'Id_Warehouse'				=> 'required|int',
								'Id_Group'					=> 'required|int',
								'Id_RegistryConfiguration'	=> 'required|int'
							);


		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {
			
			//region HISTORY VARIABLES
			$this->history->obtainOld($Request->input('Id_Registry'));
			//endregion

			$oParam = array(    $Request->input("Id_Registry"),
								$Request->input("Registry_DocumentDate"),
								$Request->input("Registry_DocumentSerie"),
								$Request->input("Registry_DocumentNumber"),
								$Request->input("Id_Provider"),
								$Request->input("Id_Warehouse"),
								$Request->input("Id_Group"),
								$Request->input("Id_RegistryConfiguration")
							);
			$oData = DB::select('call sp_registry_update(?,?,?,?,?,?,?,?)',$oParam);

			//  RESPONSE
			if ($oData[0]->Response_Success == 1) {
				//region HISTORY EXEC
				$this->history->updateBasic ( $Request->input("Id_Registry"), $Request );
				//endregion
			} else {
				
			}
			
			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);

	}
	
	public function Status(Request $Request){
		$oResponse  = array();
		$continue=true;
		$oValParams = array(    'Id_Registry'		=> 'required|int',
								'Registry_Status'	=> 'required|int',
								'RegistryDetail'	=> 'required|string'
							);


		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {
			
			//region HISTORY VARIABLES
			$this->history->obtainOld($Request->input('Id_Registry'));
			//endregion
			
			$oData = null;
			if ($Request->input('Registry_Status') == 3) {
				$oData = self::saveRegistryDetail($Request->input("RegistryDetail"));
			}
			
			$oParam = [
				$Request->input("Id_Registry"),
				$Request->input("Registry_Status"),
				$Request->header('Token'),
				''
			];

			if ($oData == null || $oData[0]->Response_Success == 1) {
				$oData = DB::select('call sp_registry_update_status(?,?,?,?)', $oParam);
			}

			if ($oData[0]->Response_Success == 1) {
				$this->history->updateBasic ( $Request->input("Id_Registry"), $Request );
			}

			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;

		}

		return ResponseBuilder::Response($oResponse);

	}

	public static function saveRegistryDetail ($RegistryDetailJSON) {
		$RegistryDetail 		= json_decode($RegistryDetailJSON);

		$oData = null;
		
		foreach ($RegistryDetail as $detail) {
			$oData = DB::select ('CALL sp_registry_detail_update_returned(?,?,?)', [
				$detail->Id_RegistryDetail,
				$detail->RegistryDetail_RefundQuantity,
				$detail->RegistryDetail_Observation
			]);
			
			
			if ($oData[0]->Response_Success == 0) {
				return $oData;
			}
		}
		return $oData;
	}

	public function Delete(Request $Request, $Id){
		$oResponse  = array();

		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {
			
			//region HISTORY
			$this->history->obtainOld($Id);
			//endregion

			$oParam = [
				$Id,
				$Request->header('Token'),
				''
			];
			$oData 	= DB::select('call sp_registry_delete(?,?)',$oParam);

			//  RESPONSE
			if ($oData[0]->Response_Success == 1) {
				//region HISTORY EXEC
				$this->history->deleteBasic ($Id, $Request);
				//endregion
			} else {
				
			}
			
			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);
	}

	public function Index(Request $Request, $Id){
		$oResponse  = array();

		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {		
			$oParam = array( $Id );
			$oData 	= DB::select('call sp_registry_index(?)',$oParam);
			
			$oResponse["Response_Status"]			= 200;
			$oResponse["Response_Code"]				= 200;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $this->oDomain." Index";
			$oResponse["Response_Data"]				= $oData;
			$oResponse["Response_Error_Message"]	= "";
			$oResponse["Response_Error_Reason"]		= "";
		}

		return ResponseBuilder::Response($oResponse);
	}

	public function Search(Request $Request){
		$oResponse  = array();
		$oValParams = array(    'Date_Start'		=> 'required|string',
                                'Date_End'			=> 'required|string',
                                'RegistryState'		=> 'required|string',
								'Registry_Status'	=> 'required|int',
								'DateType'			=> 'required|int'
							);
						
		$oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);

		if ($oResponse["Response_Code"] == 200) {
			$oParam = array(    $Request->input("Date_Start"),
								$Request->input("Date_End"),
								$Request->input("Registry_Status"),
								$Request->input("RegistryState"),
								$Request->input('DateType')
							);
			$oData  = DB::select('call sp_registry_search(?,?,?,?,?)',$oParam);

			$oResponse["Response_Status"]			= 200;
			$oResponse["Response_Code"]				= 200;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $this->oDomain." list ";
			$oResponse["Response_Data"]				= $oData;
			$oResponse["Response_Error_Message"]	= "";
			$oResponse["Response_Error_Reason"]		= "";
		}

		return ResponseBuilder::Response($oResponse);
	}
	

	public function Report_Excel (Request $Request, $Id_Registry) {
		$oResponse  = array();

		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Id($Id_Registry, $this->oDomain);

		if ($oResponse["Response_Code"] == 200) {
			$oParam = array( $Id_Registry );
			$oData = DB::select('call sp_registry_index(?)', $oParam);
			if (count($oData)) {
				$oData[0]->Registry_Detail = DB::select('call sp_registry_detail_list(?)', $oParam);
			}
			
			(new ExcelRegistryReport()) 
				->exportToExcel($oData);
		} else {
			return ResponseBuilder::Response($oResponse);
		}

		
	}
	public function GetReport(Request $Request, $Id_Registry) {
		$oResponse  = array();

		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Id($Id_Registry, $this->oDomain);

		if ($oResponse["Response_Code"] == 200) {
			$oParam = array( $Id_Registry );
			$oData = DB::select('call sp_registry_index(?)', $oParam);
			if (count($oData)) {
				$oData[0]->Registry_Detail = DB::select('call sp_registry_detail_list(?)', $oParam);
			}
			$oResponse["Response_Status"]			= 200;
			$oResponse["Response_Code"]				= 200;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $this->oDomain." list ";
			$oResponse["Response_Data"]				= $oData;
			$oResponse["Response_Error_Message"]	= "";
			$oResponse["Response_Error_Reason"]		= "";
		}

		return ResponseBuilder::Response($oResponse);
	}


	public function Selector(Request $Request,$Id){
		if( is_numeric($Id) ){
			return SELF::Index( $Request,$Id );
		}else{
			return SELF::Search( $Request,$Id );
		}
	}

	
}