<?php

namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Group\Application\UpdateDateUpdate\UpdateGroupDateUpdateQuery;
use App\Modules\GroupPassenger\Application\UpdateReview\UpdateReviewGroupPassengerQuery;
use App\Modules\GroupPassenger\Domain\GroupPassengerReviewStatus;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use Illuminate\Support\Facades\DB;

class c_Group_Passenger extends Controller
{
    private $oDomain;
    /** @var HistoryData */
    private $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->oDomain = "Group Passenger";
        $this->history = new HistoryData(HistoryTables::GROUP_PASSENGER);
    }

    public static function findGroup($Id_GroupPassenger)
    {
        $found = DB::select('call sp_group_passenger_index(?,?)', [$Id_GroupPassenger, '']);
        return count($found) ? $found[0]->Id_Group : null;
    }

    public function Insert_All(Request $Request)
    {
        $oSucces    = true;
        $oResponse  = array();
        $oValParams = array(
            'Id_Group'  => 'required|int',
            'Passenger' => 'required|string'
        );

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);

        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $oPassenger = json_decode($Request->input("Passenger"));

            for ($k = 0; $k < count($oPassenger); $k++) {
                $oParam = array(
                    1,
                    $Request->input("Id_Group"),
                    $oPassenger[$k]->Id_BookingTourPassenger
                );
                $oData = DB::select('call sp_group_passenger_insert(?,?,?)', $oParam);

                if ($oData[0]->Response_Success == 0) {
                    $oSucces = false;
                    break;
                }
                $group = $this->getGroup($Request->input('Id_Group'));
                $this->addQuestionsToPassenger($group, $oPassenger[$k]->Id_BookingTourPassenger, $oData[0]->Response_Id);
                $this->history->obtainOld($oData[0]->Response_Id);
                $this->history->insert(
                    $this->history->oldValue,
                    $Request,
                    $Request->input("Id_Group"),
                );
                $this->queryBus->ask(new UpdateGroupDateUpdateQuery($Request->input("Id_Group")));
            }

            if ($oSucces == true) {
                $oData = array(
                    array(
                        "Response_Status"   => 200,
                        "Response_Code"     => 200,
                        "Response_Message"  => "Pasajeros guardados con éxito",
                        "Response_Reason"   => null
                    )
                );

                $oData = json_decode(json_encode($oData));
            }

            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function Insert(Request $Request)
    {
        $oResponse  = array();
        $oValParams = array(
            'GroupPassenger_Type'   => 'required|int',
            'Id_Group'              => 'required|int',
            'Id'                    => 'required|int'
        );

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);

        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $oParam = array(
                $Request->input("GroupPassenger_Type"),
                $Request->input("Id_Group"),
                $Request->input("Id")
            );
            $oData = DB::select('call sp_group_passenger_insert(?,?,?)', $oParam);

            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                $this->history->obtainOld($oData[0]->Response_Id);
                $this->history->insert(
                    $this->history->oldValue,
                    $Request,
                    $Request->input("Id_Group"),
                );
                $this->queryBus->ask(new UpdateGroupDateUpdateQuery($Request->input("Id_Group")));
            } else {
            }



            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }

    private function getGroup($idGroup)
    {
        return DB::select('CALL sp_group_index(?)', [$idGroup])[0];
    }

    private function addQuestionsToPassenger($group, $idBookingTourPassenger, $idGroupPassenger)
    {
        if ($group->Group_Status == 2 && $group->Group_ServiceType == 1) {
            $questions = $this->getQuestionList($group->Id_Service);

            for ($i = 0; $i < count($questions); $i++) {
                $question = $questions[$i];
                if (!$this->questionTypeProviderAvailableFor($question->QuestionTypeProvider, 2, 0)) {
                    continue;
                }
                $oParam = [
                    $idGroupPassenger,
                    $idBookingTourPassenger,
                    $group->Id_Group,
                    $questions[$i]->Id_Question
                ];
                DB::select('call sp_passenger_review_insert(?,?,?,?)', $oParam);
            }
            $this->queryBus->ask(new UpdateReviewGroupPassengerQuery(
                $idGroupPassenger,
                GroupPassengerReviewStatus::PENDING
            ));
        }
    }

    private function getQuestionList($idTour)
    {
        return array_map(
            function ($tql) {
                $tql->QuestionTypeProvider = json_decode($tql->QuestionTypeProviderJSON);
                return $tql;
            },
            DB::select('call sp_tour_question_list(?)', [$idTour])
        );
    }

    private function questionTypeProviderAvailableFor(array $questionTypeProviderList, int $questionTypeProviderForPassenger, int $idTypeProvider)
    {
        $show = true;
        foreach ($questionTypeProviderList as $qtp) {
            if ($qtp->QuestionTypeProvider_ForPassenger != $questionTypeProviderForPassenger) {
                continue;
            }

            if ($idTypeProvider == 0) {
                if ($idTypeProvider == $qtp->Id_TypeProvider) {
                    $show = $qtp->QuestionTypeProvider_Show == 2;
                    break;
                } else {
                    $show = true;
                    break;
                }
            } else {
                if ($qtp->Id_TypeProvider == 0) {
                    $show = $qtp->QuestionTypeProvider_Show == 2;
                } else {
                    if ($qtp->Id_TypeProvider == $idTypeProvider) {
                        $show = $qtp->QuestionTypeProvider_Show == 2;
                        break;
                    }
                }
            }
        }
        return $show;
    }

    public function Update(Request $Request)
    {
        $oResponse  = array();
        $oValParams = [
            'Id_GroupPassenger'     => 'required|int',
            'GroupPassenger_Type'   => 'required|int',
            'Id_Group'              => 'required|int',
            'Id'                    => 'required|int'
        ];

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);

        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $this->history->obtainOld();
            $oParam = array(
                $Request->input("Id_GroupPassenger"),
                $Request->input("GroupPassenger_Type"),
                $Request->input("Id_Group"),
                $Request->input("Id")
            );
            $oData = DB::select('call sp_group_passenger_update(?,?,?,?)', $oParam);

            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                $this->history->insert(
                    [$Request->all()],
                    $Request,
                    $Request->input("Id_Group"),
                );
                $this->queryBus->ask(new UpdateGroupDateUpdateQuery($Request->input("Id_Group")));
            } else {
            }

            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function Delete(Request $Request, $Id)
    {
        $oResponse  = array();

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Id($Id, $this->oDomain);

        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $this->history->obtainOld($Id);
            $idGroup = self::findGroup($Id);

            $oParam = array($Id);
            $oData  = DB::select('call sp_group_passenger_delete(?)', $oParam);

            if ($oData[0]->Response_Success == 1) {
                $this->history->delete(
                    $idGroup,
                    $this->history->oldValue,
                    $Request
                );
                $this->queryBus->ask(new UpdateGroupDateUpdateQuery($idGroup));
            } else {
            }

            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function Index(Request $Request, $Id)
    {
        $oResponse  = array();

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Id($Id, $this->oDomain);

        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $oParam = array($Id, config('var.PATH_PUBLIC') . config('var.USER_COUNTRY_THUMB'));
            $oData  = DB::select('call sp_group_passenger_index(?,?)', $oParam);

            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain . " Index";
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function List(Request $Request, $Id_Group)
    {
        $oResponse  = array();

        $oResponse = ParamsValidator::Validate_Id($Id_Group, $this->oDomain);


        if ($oResponse["Response_Code"] == 200) {
            $Path_Thumb     = config("var.PATH_PUBLIC") . config("var.USER_COUNTRY_THUMB");
            $oParam         = array(
                $Id_Group,
                $Path_Thumb,
                $Request->header("Token"),
                $Request->ip()
            );
            $oData          = DB::select('call sp_group_passenger_list(?,?,?,?)', $oParam);

            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain . " list";
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }
}
