<?php

namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Group\Application\UpdateDateUpdate\UpdateGroupDateUpdateQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use Illuminate\Support\Facades\DB;

class c_Group_Equipment extends Controller
{
    private $oDomain;
    /** @var HistoryData */
    private $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->oDomain = "Group Equipment";
        $this->history = new HistoryData(HistoryTables::group_equipment);
    }

    public static function findGroup($Id_GroupProvider)
    {
        $found = DB::select('call sp_group_equipment_index(?)', [$Id_GroupProvider]);
        return count($found) ? $found[0]->Id_Group : null;
    }

    public function Insert(Request $Request)
    {
        $oResponse  = array();
        $oValParams = array(
            'GroupEquipment_Quantity'    => 'required|int',
            'Id_Group'                    => 'required|int',
            'Id_Item'                    => 'required|int'
        );


        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);

        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $oParam = array(
                $Request->input("GroupEquipment_Quantity"),
                $Request->input("Id_Group"),
                $Request->input("Id_Item"),
                0,
                0,
                1
            );
            $oData = DB::select('call sp_group_equipment_insert(?,?,?,?,?,?)', $oParam);

            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                $this->history->insert(
                    $this->history->old($oData[0]->Response_Id),
                    $Request,
                    $Request->input("Id_Group")
                );
                $this->queryBus->ask(new UpdateGroupDateUpdateQuery($Request->input('Id_Group')));
            } else {
            }

            $oResponse["Response_Status"]            = $oData[0]->Response_Status;
            $oResponse["Response_Code"]                = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]            = $this->oDomain;
            $oResponse["Response_Message"]            = $oData[0]->Response_Message;
            $oResponse["Response_Data"]                = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]        = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function Update(Request $Request)
    {
        $oResponse  = array();
        $oValParams = array(
            'Id_GroupEquipment'            => 'required|int',
            'GroupEquipment_Quantity'    => 'required|int',
            'Id_Group'                    => 'required|int',
            'Id_Item'                    => 'required|int'
        );


        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);

        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $this->history->obtainOld($Request->input("Id_GroupEquipment"));

            $oParam = array(
                $Request->input("Id_GroupEquipment"),
                $Request->input("GroupEquipment_Quantity"),
                $Request->input("Id_Group"),
                $Request->input("Id_Item"),
                0,
                0
            );
            $oData = DB::select('call sp_group_equipment_update(?,?,?,?,?,?)', $oParam);

            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                $this->history->update(
                    $Request->input("Id_Group"),
                    $this->history->oldValue,
                    [$Request->all()],
                    $Request
                );
                $this->queryBus->ask(new UpdateGroupDateUpdateQuery($Request->input('Id_Group')));
            } else {
            }

            $oResponse["Response_Status"]            = $oData[0]->Response_Status;
            $oResponse["Response_Code"]                = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]            = $this->oDomain;
            $oResponse["Response_Message"]            = $oData[0]->Response_Message;
            $oResponse["Response_Data"]                = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]        = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function Delete(Request $Request, $Id)
    {
        $oResponse  = array();

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Id($Id, $this->oDomain);

        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $this->history->obtainOld($Id);
            $Id_Group = self::findGroup($Id);

            $oParam = array($Id);
            $oData     = DB::select('call sp_group_equipment_delete(?)', $oParam);

            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                $this->history->delete(
                    $Id_Group,
                    $this->history->oldValue,
                    $Request
                );
                $this->queryBus->ask(new UpdateGroupDateUpdateQuery($Id_Group));
            } else {
            }

            $oResponse["Response_Status"]            = $oData[0]->Response_Status;
            $oResponse["Response_Code"]                = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]            = $this->oDomain;
            $oResponse["Response_Message"]            = $oData[0]->Response_Message;
            $oResponse["Response_Data"]                = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]        = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function Index(Request $Request, $Id)
    {
        $oResponse  = array();

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Id($Id, $this->oDomain);

        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $oParam = array($Id);
            $oData     = DB::select('call sp_group_equipment_index(?)', $oParam);

            $oResponse["Response_Status"]            = 200;
            $oResponse["Response_Code"]                = 200;
            $oResponse["Response_Domain"]            = $this->oDomain;
            $oResponse["Response_Message"]            = $this->oDomain . " Index";
            $oResponse["Response_Data"]                = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]        = "";
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function List(Request $Request, $Id_Group, $Id)
    {
        $oResponse  = array();

        $oResponse = ParamsValidator::Validate_Id($Id_Group, $this->oDomain);


        if ($oResponse["Response_Code"] == 200) {

            $oParam     = array($Id_Group, $Id);
            $oData      = DB::select('call sp_group_equipment_list(?,?)', $oParam);

            $oResponse["Response_Status"]            = 200;
            $oResponse["Response_Code"]                = 200;
            $oResponse["Response_Domain"]            = $this->oDomain;
            $oResponse["Response_Message"]            = $this->oDomain . " list";
            $oResponse["Response_Data"]                = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]        = "";
        }

        return ResponseBuilder::Response($oResponse);
    }
}
