<?php

namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Group\Application\UpdateDateUpdate\UpdateGroupDateUpdateQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use Illuminate\Support\Facades\DB;
use Intervention\Image\ImageManagerStatic as Image;

class c_Group_Activity extends Controller
{
	private $oDomain;
	/** @var HistoryData */
	private $history;

	public function __construct(
		private QueryBus $queryBus
	) {
		$this->oDomain = "Group Activity";
		$this->history = new HistoryData(HistoryTables::group_activity);
	}

	public static function findGroup($Id_GroupActivity)
	{
		$found = DB::select('CALL sp_group_activity_index(?)', [$Id_GroupActivity]);
		return count($found) ? $found[0]->Id_Group : null;
	}

	public function Insert(Request $Request)
	{
		$oResponse  = array();
		$oValParams = array(
			'GroupActivity_Date'			=> 'required|string',
			'GroupActivity_Title'			=> 'required|string|max:250',
			'Id_Group'						=> 'required|int'
		);


		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);

		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {

			$oParam = array(
				$Request->input("GroupActivity_Date"),
				$Request->input("GroupActivity_Title"),
				$Request->input("Id_Group")
			);
			$oData = DB::select('call sp_group_activity_insert(?,?,?)', $oParam);

			//  RESPONSE
			if ($oData[0]->Response_Success == 1) {
				$this->history->insert(
					[$Request->all()],
					$Request,
					$Request->input('Id_Group')
				);
				$this->queryBus->ask(new UpdateGroupDateUpdateQuery($Request->input("Id_Group")));
			} else {
			}

			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);
	}
	public function Update(Request $Request)
	{
		$oResponse  = array();
		$oValParams = array(
			'Id_GroupActivity'			=> 'required|int',
			'GroupActivity_Date'		=> 'required|string',
			'GroupActivity_Title'		=> 'required|string|max:250',
			'Id_Group'					=> 'required|int'
		);


		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);

		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {
			$this->history->obtainOld($Request->input("Id_GroupActivity"));
			$oParam = array(
				$Request->input("Id_GroupActivity"),
				$Request->input("GroupActivity_Date"),
				$Request->input("GroupActivity_Title"),
				$Request->input("Id_Group")
			);
			$oData = DB::select('call sp_group_activity_update(?,?,?,?)', $oParam);

			//  RESPONSE
			if ($oData[0]->Response_Success == 1) {
				$this->history->update(
					$Request->input("Id_Group"),
					$this->history->oldValue,
					[$Request->all()],
					$Request
				);
				$this->queryBus->ask(new UpdateGroupDateUpdateQuery($Request->input("Id_Group")));
			} else {
			}

			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);
	}
	public function Delete(Request $Request, $Id)
	{
		$oResponse  = array();

		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Id($Id, $this->oDomain);

		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {
			$this->history->obtainOld($Id);
			$Id_Group = self::findGroup($Id);
			$oParam = array($Id);
			$oData 	= DB::select('call sp_group_activity_delete(?)', $oParam);

			//  RESPONSE
			if ($oData[0]->Response_Success == 1) {
				$this->history->delete(
					$Id_Group,
					$this->history->oldValue,
					$Request
				);
				$this->queryBus->ask(new UpdateGroupDateUpdateQuery($Id_Group));
			} else {
			}

			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);
	}
	public function Index(Request $Request, $Id)
	{
		$oResponse  = array();

		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Id($Id, $this->oDomain);

		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {
			$oParam = array($Id);
			$oData 	= DB::select('call sp_group_activity_index(?)', $oParam);


			$oResponse["Response_Status"]			= 200;
			$oResponse["Response_Code"]				= 200;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $this->oDomain . " Index";
			$oResponse["Response_Data"]				= $oData;
			$oResponse["Response_Error_Message"]	= "";
			$oResponse["Response_Error_Reason"]		= "";
		}

		return ResponseBuilder::Response($oResponse);
	}
	public function List(Request $Request, $Id_Group)
	{
		$oResponse  = array();

		$oResponse = ParamsValidator::Validate_Id($Id_Group, $this->oDomain);

		if ($oResponse["Response_Code"] == 200) {

			$oParam = array($Id_Group);
			$oData  = DB::select('call sp_group_activity_list(?)', $oParam);

			$oResponse["Response_Status"]			= 200;
			$oResponse["Response_Code"]				= 200;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $this->oDomain . " list ";
			$oResponse["Response_Data"]				= $oData;
			$oResponse["Response_Error_Message"]	= "";
			$oResponse["Response_Error_Reason"]		= "";
		}

		return ResponseBuilder::Response($oResponse);
	}
	public function Report(Request $Request)
	{
		$oResponse  = array();
		$oValParams = array(
			'Date_Start'	=> 'required|string',
			'Date_End'		=> 'required|string'
		);


		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);

		if ($oResponse["Response_Code"] == 200) {

			$oParam = array(
				$Request->input("Date_Start"),
				$Request->input("Date_End")
			);
			$oData  = DB::select('call sp_group_activity_report(?,?)', $oParam);

			$oData = array_map(function ($data) {
				$data->GroupActivityDetail = DB::select('call sp_group_activity_detail_list(?)', [$data->Id_GroupActivity]);
				return $data;
			}, $oData);

			$oResponse["Response_Status"]			= 200;
			$oResponse["Response_Code"]				= 200;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $this->oDomain . " report";
			$oResponse["Response_Data"]				= $oData;
			$oResponse["Response_Error_Message"]	= "";
			$oResponse["Response_Error_Reason"]		= "";
		}

		return ResponseBuilder::Response($oResponse);
	}
}
