<?php

namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use Illuminate\Support\Facades\DB;

class c_Country extends Controller
{
    private $oDomain;
    /** @var HistoryData */
    private $history;

    public function __construct()
    {
        $this->oDomain = "Country";
        $this->history = new HistoryData(HistoryTables::COUNTRY);
    }

    public function Insert(Request $Request)
    {
        $oResponse  = array();
        $oValParams = array(
            'Country_Code'      => 'required|string|max:3',
            'Country_Name'        => 'required|string|max:250',
            'Country_Status'    => 'required|int'
        );


        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);

        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {

            $oParam = array(
                trim($Request->input("Country_Code")),
                trim($Request->input("Country_Name")),
                $Request->input("Country_Status")
            );
            $oData = DB::select('call sp_country_insert(?,?,?)', $oParam);

            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                $this->history->insertBasic($Request);
            } else {
            }

            $oResponse["Response_Status"]            = $oData[0]->Response_Status;
            $oResponse["Response_Code"]                = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]            = $this->oDomain;
            $oResponse["Response_Message"]            = $oData[0]->Response_Message;
            $oResponse["Response_Data"]                = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]        = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }
    public function Update(Request $Request)
    {
        $oResponse  = array();
        $oValParams = array(
            'Id_Country'          => 'required|int',
            'Country_Code'      => 'required|string|max:3',
            'Country_Name'        => 'required|string|max:250',
            'Country_Status'    => 'required|int'
        );


        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);

        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {

            $this->history->obtainOld($Request->input('Id_Country'));
            
            $oParam = array(
                $Request->input("Id_Country"),
                trim($Request->input("Country_Code")),
                trim($Request->input("Country_Name")),
                $Request->input("Country_Status")
            );
            $oData = DB::select('call sp_country_update(?,?,?,?)', $oParam);

            //
            //  RESPONSE
            //
            if ($oData[0]->Response_Success == 1) {
                $this->history->updateBasic($Request->input("Id_Country"), $Request);
            } else {
            }

            $oResponse["Response_Status"]            = $oData[0]->Response_Status;
            $oResponse["Response_Code"]                = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]            = $this->oDomain;
            $oResponse["Response_Message"]            = $oData[0]->Response_Message;
            $oResponse["Response_Data"]                = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]        = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }
    public function Delete(Request $Request, $Id)
    {
        $oResponse  = array();

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Id($Id, $this->oDomain);

        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $this->history->obtainOld($Id);
            $oParam = array($Id);
            $oData     = DB::select('call sp_country_delete(?)', $oParam);
            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                $this->history->deleteBasic($Id, $Request);
            } else {
            }

            $oResponse["Response_Status"]            = $oData[0]->Response_Status;
            $oResponse["Response_Code"]                = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]            = $this->oDomain;
            $oResponse["Response_Message"]            = $oData[0]->Response_Message;
            $oResponse["Response_Data"]                = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]        = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }
    public function Index(Request $Request, $Id)
    {
        $oResponse  = array();

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Id($Id, $this->oDomain);

        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $oParam = array($Id);
            $oData     = DB::select('call sp_country_index(?)', $oParam);

            $oResponse["Response_Status"]            = 200;
            $oResponse["Response_Code"]                = 200;
            $oResponse["Response_Domain"]            = $this->oDomain;
            $oResponse["Response_Message"]            = $this->oDomain . " Index";
            $oResponse["Response_Data"]                = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]        = "";
        }

        return ResponseBuilder::Response($oResponse);
    }
    public function List(Request $Request, $Id)
    {
        $oResponse  = array();

        $oResponse = ParamsValidator::Validate_Action($Id, $this->oDomain);

        if ($oResponse["Response_Code"] == 200) {
            $oParam = array($Id);
            $oData  = DB::select('call sp_country_list(?)', $oParam);

            $oResponse["Response_Status"]            = 200;
            $oResponse["Response_Code"]                = 200;
            $oResponse["Response_Domain"]            = $this->oDomain;
            $oResponse["Response_Message"]            = $this->oDomain . " list " . $Id;
            $oResponse["Response_Data"]                = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]        = "";
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function Selector(Request $Request, $Id)
    {
        if (is_numeric($Id)) {
            return SELF::Index($Request, $Id);
        } else {
            return SELF::List($Request, $Id);
        }
    }
}
