<?php
namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;

use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use Intervention\Image\ImageManagerStatic as Image;

class c_Booking_Activity extends Controller
{
	private $oDomain;

	public function __construct()
	{
		$this->oDomain = "Booking Activity";
	}

	public function Insert(Request $Request){
		$oResponse  = array();
		$oValParams = array(    'BookingActivity_Date'			=> 'required|string',
								'BookingActivity_Title'			=> 'required|string|max:250',
								'BookingActivity_Description'	=> 'required|string',
                                'Id_BookingTour'				=> 'required|int'
							);


		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {	
			
			$oParam = array(	$Request->input("BookingActivity_Date"),
								$Request->input("BookingActivity_Title"),
								$Request->input("BookingActivity_Description"),
								$Request->input("Id_BookingTour")
							);
			$oData = DB::select('call sp_booking_activity_insert(?,?,?,?)',$oParam);

			//  RESPONSE
			if($oData[0]->Response_Success == 1){
				
			}else{
				
			}
			
			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);
		
	}
	public function Update(Request $Request){
		$oResponse  = array();
		$oValParams = array(    'Id_BookingActivity'			=> 'required|int',
								'BookingActivity_Date'			=> 'required|string',
								'BookingActivity_Title'			=> 'required|string|max:250',
								'BookingActivity_Description'	=> 'required|string',
								'Id_BookingTour'				=> 'required|int'
							);


		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {			
			$oParam = array(	$Request->input("Id_BookingActivity"),
								$Request->input("BookingActivity_Date"),
								$Request->input("BookingActivity_Title"),
								$Request->input("BookingActivity_Description"),
								$Request->input("Id_BookingTour")
							);
			$oData = DB::select('call sp_booking_activity_update(?,?,?,?,?)',$oParam);

			//  RESPONSE
			if($oData[0]->Response_Success == 1){
				
			}else{
				
			}
			
			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);

	}
	public function Delete(Request $Request, $Id){
		$oResponse  = array();

		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {			
			$oParam = array( $Id );
			$oData 	= DB::select('call sp_booking_activity_delete(?)',$oParam);

			//  RESPONSE
			if($oData[0]->Response_Success == 1){
				
			}else{
				
			}
			
			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);
	}
	public function Index(Request $Request, $Id){
		$oResponse  = array();

		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {		
			$oParam = array( $Id );
			$oData 	= DB::select('call sp_booking_activity_index(?)',$oParam);
			

			$oResponse["Response_Status"]			= 200;
			$oResponse["Response_Code"]				= 200;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $this->oDomain." Index";
			$oResponse["Response_Data"]				= $oData;
			$oResponse["Response_Error_Message"]	= "";
			$oResponse["Response_Error_Reason"]		= "";
		}

		return ResponseBuilder::Response($oResponse);
	}
	public function List(Request $Request, $Id_BookingTour){
		$oResponse  = array();
	
		$oResponse = ParamsValidator::Validate_Id($Id_BookingTour,$this->oDomain);

		if ($oResponse["Response_Code"] == 200) {

			$oParam = array( $Id_BookingTour );
			$oData  = DB::select('call sp_booking_activity_list(?)',$oParam);

			$oResponse["Response_Status"]			= 200;
			$oResponse["Response_Code"]				= 200;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $this->oDomain." list ";
			$oResponse["Response_Data"]				= $oData;
			$oResponse["Response_Error_Message"]	= "";
			$oResponse["Response_Error_Reason"]		= "";
		}

		return ResponseBuilder::Response($oResponse);
	}
	public function Report(Request $Request){
		$oResponse  = array();
		$oValParams = array(    'Date_Start'	=> 'required|string',
								'Date_End'		=> 'required|string'
							);


		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);

		if ($oResponse["Response_Code"] == 200) {

			$oParam = array(	$Request->input("Date_Start"),
								$Request->input("Date_End")
							);
			$oData  = DB::select('call sp_booking_activity_report(?,?)',$oParam);

			$oResponse["Response_Status"]			= 200;
			$oResponse["Response_Code"]				= 200;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $this->oDomain." report";
			$oResponse["Response_Data"]				= $oData;
			$oResponse["Response_Error_Message"]	= "";
			$oResponse["Response_Error_Reason"]		= "";
		}

		return ResponseBuilder::Response($oResponse);
	}
	
	
}