<?php

namespace App\Http\Controllers\Owner\WebContactMessage;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\WebContactMessage\Application\Delete\DeleteWebContactMessageQuery;
use App\Modules\WebContactMessage\Application\Delete\DeleteWebContactMessageQueryResponse;

class WebContactMessageDeleteController extends Controller
{
    /** @var HistoryData */
    private $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->history = new HistoryData(HistoryTables::WEB_CONTACT_MESSAGE);
    }

    public function __invoke(Request $Request, int $Id)
    {
        $this->history->obtainOld($Id);

        /** @var DeleteWebContactMessageQueryResponse $response */
        $response = $this->queryBus->ask(new DeleteWebContactMessageQuery($Id));

        $this->history->deleteBasic($Id, $Request);

        return ResponseBuilder::Response($response->response());
    }
}
