<?php

namespace App\Http\Controllers\Owner\TypeBookingAssign;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\TypeBookingAssign\Application\Update\UpdateTypeBookingAssignQuery;
use App\Modules\TypeBookingAssign\Application\Update\UpdateTypeBookingAssignQueryResponse;
use App\Modules\TypeBookingAssign\Infraestructure\TypeBookingAssignValidators;

class TypeBookingAssignUpdateController extends Controller
{
    private $domain;
    /** @var HistoryData */
    private $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "TypeBookingAssign";
        $this->history = new HistoryData(HistoryTables::TYPE_BOOKING_ASSIGN);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, TypeBookingAssignValidators::UPDATE);

        /** @var UpdateTypeBookingAssignQueryResponse $response */
        $response = $this->queryBus->ask(new UpdateTypeBookingAssignQuery(
            $request->input('Id_TypeBookingAssign'),
            $request->input('TypeBookingAssign_Name'),
            $request->input('TypeBookingAssign_Abrv'),
            $request->input('TypeBookingAssign_Score'),
            $request->input('TypeBookingAssign_Status')
        ));

        $this->history->updateBasic($request->input("Id_TypeBookingAssign"), $request);

        return ResponseBuilder::Response($response->response());
    }
}
