<?php

namespace App\Http\Controllers\Owner\TourHtlCamp;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\TourHtlCamp\Application\TourHtlCampIndexer;
use App\Modules\TourHtlCamp\Domain\IdTourHtlCamp;
use App\Modules\TourHtlCamp\Infraestructure\MysqlTourHtlCampRepository;

class TourHtlCampIndexController extends Controller
{
    private $oDomain;
    /** @var HistoryData */
    private $history;

    public function __construct()
    {
        $this->oDomain = "TourHtlCamp";
        $this->history = new HistoryData(HistoryTables::TOUR_HTL_CAMP);
    }

    public function __invoke($Id)
    {
        $oResponse = (new TourHtlCampIndexer(new MysqlTourHtlCampRepository))->__invoke(new IdTourHtlCamp($Id));
        return ResponseBuilder::Response($oResponse);
    }
}
