<?php

namespace App\Http\Controllers\Owner\StatusGroup;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\StatusGroup\Application\Update\UpdateStatusGroupQuery;
use App\Modules\StatusGroup\Application\Update\UpdateStatusGroupQueryResponse;
use App\Modules\StatusGroup\Infraestructure\StatusGroupValidators;

class StatusGroupUpdateController extends Controller
{
    private $domain;
    /** @var HistoryData */
    private $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "StatusGroup";
        $this->history = new HistoryData(HistoryTables::STATUS_GROUP);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, StatusGroupValidators::UPDATE);

        /** @var UpdateStatusGroupQueryResponse $response */
        $response = $this->queryBus->ask(new UpdateStatusGroupQuery(
            $request->input('Id_StatusGroup'),
            $request->input('StatusGroup_Name'),
            $request->input('StatusGroup_Abrv'),
            $request->input('StatusGroup_Color'),
            $request->input('StatusGroup_Status')
        ));

        $this->history->updateBasic($request->input("Id_StatusGroup"), $request);

        return ResponseBuilder::Response($response->response());
    }
}
