<?php

namespace App\Http\Controllers\Owner\StatusGroup;

use App\Http\Controllers\Controller;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\StatusGroup\Application\Index\IndexStatusGroupQuery;
use App\Modules\StatusGroup\Application\Index\IndexStatusGroupQueryResponse;

class StatusGroupIndexController extends Controller
{
    private $domain = 'StatusGroup';
    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($Id)
    {
        /** @var IndexStatusGroupQueryResponse $response */
        $response = $this->queryBus->ask(new IndexStatusGroupQuery($Id));

        return ResponseBuilder::Response(ResponseBuilder::buildSelectResponse($response->response(), '', $this->domain));
    }
}
