<?php

namespace App\Http\Controllers\Owner\Passenger;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\Passenger\Application\PassengerSearchWithReview;
use App\Modules\Passenger\Infraestructure\MysqlPassengerSearchWithReviewRepository;
use App\Modules\Passenger\Infraestructure\PassengerSearchWithReviewValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;
use App\Modules\Shared\Infraestructure\QueryList\LaravelListValidator;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;

final class PassengerSearchWithReviewReport extends Controller
{
    private $oDomain;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->oDomain = 'Passenger';
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator)->validate($request->all(), $this->oDomain, PassengerSearchWithReviewValidators::BASIC);
        $listInput = (new LaravelListValidator($request))->__invoke(LaravelListValidator::FIND, $this->oDomain);
        $response = (new PassengerSearchWithReview(new MysqlPassengerSearchWithReviewRepository))
            ->__invoke(
                new DateStart($request->input('DateStart')),
                new DateEnd($request->input('DateEnd')),
                $request->input('Range'),
                $request->input('Id_Group'),
                $request->input('Action'),
                $listInput,
                1
            );
        return ResponseBuilder::Response($response);
    }
}
