<?php

namespace App\Http\Controllers\Owner\LeadBookingTour;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\LeadBookingTour\Application\Update\LeadBookingTourUpdaterQuery;
use App\Modules\LeadBookingTour\Application\Update\LeadBookingTourUpdaterResponse;
use App\Modules\LeadBookingTour\Infraestructure\LeadBookingTourValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class LeadBookingTourUpdateController extends Controller
{
    private $domain;
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "LeadBookingTour";
        $this->history = new HistoryData(HistoryTables::LEAD_BOOKING_TOUR);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, LeadBookingTourValidators::UPDATE);

        $this->history->obtainOld($request->input("Id_LeadBookingTour"));

        /** @var LeadBookingTourUpdaterResponse $response */
        $response = $this->queryBus->ask(new LeadBookingTourUpdaterQuery(
            $request->input('Id_LeadBookingTour'),
            $request->input('LeadBookingTour_DateStart'),
            $request->input('LeadBookingTour_PickUp'),
            $request->input('LeadBookingTour_Type'),
            $request->input('LeadBookingTour_NoPax'),
            $request->input('LeadBookingTour_Status')
        ));

        $this->history->updateBasic($request->input("Id_LeadBookingTour"), $request);
        return ResponseBuilder::Response($response->response());
    }
}
