<?php
namespace App\Http\Controllers\Owner\LeadBookingService;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\LeadBookingService\Application\List\LeadBookingServiceListerQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class LeadBookingServiceListController extends Controller
{
    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($Id_LeadBookingTour, $Action)
    {
        /** @var LeadBookingServiceListerResponse $response */
        $response = $this->queryBus->ask(new LeadBookingServiceListerQuery($Id_LeadBookingTour, $Action));

        return ResponseBuilder::Response($response->response());
    }
}
