<?php
namespace App\Http\Controllers\Owner\LeadBooking;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\LeadBooking\Application\List\LeadBookingListerQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class LeadBookingListController extends Controller
{
    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($Action)
    {
        /** @var LeadBookingListerResponse $response */
        $response = $this->queryBus->ask(new LeadBookingListerQuery($Action));

        return ResponseBuilder::Response($response->response());
    }
}
