<?php

namespace App\Http\Controllers\Owner\Info;

use App\Http\Controllers\Owner\BookingCreator;
use App\Http\Controllers\Owner\Info\Release93\AvailabilityCalendar;
use App\Http\Controllers\Owner\Info\Release93\CampsCalendar;
use App\Http\Controllers\Owner\Passenger\PassengerUpdater;
use App\Modules\HtlCamp\Domain\InsertHtlCamp;
use App\Modules\HtlCampBooking\Application\Create\CreateHtlCampBookingQuery;
use App\Modules\HtlCampBooking\Application\CreateWithPassengers\CreateWithPassengersHtlCampBookingQuery;
use App\Modules\HtlCampBooking\Application\CreateWithPassengers\CreateWithPassengersHtlCampBookingResponse;
use App\Modules\HtlCampBooking\Application\Update\UpdateHtlCampBookingQuery;
use App\Modules\HtlCampBooking\Application\UpdateDateStart\UpdateDateStartHtlCampBookingQuery;
use App\Modules\HtlCampSchedule\Application\ReloadAmount\ReloadAmountHtlCampScheduleQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\DateUtils;
use GuzzleHttp\Client;
use Illuminate\Support\Facades\DB;

class Release93Controller
{
    private $availabilityCalendar = [];
    private $htlCampBooking = [];
    private $htlCampSchedule = [];
    private $tourHtlCamp = [];
    private $bookings = [];

    public function __construct(
        private QueryBus $queryBus,
        private PassengerUpdater $passengerUpdater,
        private BookingCreator $bookingCreator
    ) {}

    public function __invoke()
    {
        $dateStart = '2024-01-01';
        $dateEnd = '2024-12-31';
        // $this->checkAllBookingTours($dateStart, $dateEnd);
        // $this->getNotEqualHtlCamp();
        // $this->reDate();
    }
    private static $api = 'https://api.salkantay-trekking.com/v1/owner/htlCampBooking';

    private function reDate()
    {
        $dates = [
            '29944' => ['2024-04-17 00:00:00', '2024-04-18 00:00:00'],
            '37467' => ['2024-05-16 00:00:00', '2024-05-17 00:00:00'],
            '37466' => ['2024-05-16 00:00:00', '2024-05-17 00:00:00'],
            '38105' => ['2024-05-21 00:00:00', '2024-05-22 00:00:00'],
            '38104' => ['2024-05-21 00:00:00', '2024-05-22 00:00:00'],
            '38920' => ['2024-06-06 00:00:00', '2024-06-07 00:00:00'],
            '38302' => ['2024-06-08 00:00:00', '2024-06-09 00:00:00'],
            '38301' => ['2024-06-07 00:00:00', '2024-06-09 00:00:00'],
            '36839' => ['2024-07-09 00:00:00', '2024-07-10 00:00:00'],
            '41659' => ['2024-08-11 00:00:00', '2024-08-12 00:00:00'],
            '41660' => ['2024-08-12 00:00:00', '2024-08-13 00:00:00'],
            '36778' => ['2024-08-27 00:00:00', '2024-08-28 00:00:00'],
            '36777' => ['2024-08-27 00:00:00', '2024-08-28 00:00:00'],
            '35836' => ['2024-09-13 00:00:00', '2024-09-14 00:00:00'],
            '35837' => ['2024-09-14 00:00:00', '2024-09-15 00:00:00'],
            '38477' => ['2024-10-24 00:00:00', '2024-10-25 00:00:00'],
        ];
        foreach ($dates as $key => $date) {
            $this->send($key, $date[0]);
            $this->send($key, $date[1]);
        }
    }

    private function send($idHtlCampBooking, $date)
    {

        $client = new Client();
        $headers = [
            "Cache-Control" => "no-cache",
            "Content-Type" => "application/json",
            "User-Agent" => "PostmanRuntime/7.41.1",
            "Accept" => "*/*",
            "Accept-Encoding" => "gzip, deflate, br",
            "Connection" => "keep-alive",
            "Token" => "SY-07c25fdfaa9deec0bcb465314591188818e4bb3c3U4JH0-OWN",
            "Url" => "/18085",
        ];
        $client->request(
            'PUT',
            self::$api,
            [
                'form_params' => [
                    "Id_HtlCampBooking" => $idHtlCampBooking,
                    "HtlCampBooking_DateStart" => $date,
                    "HtlCampBooking_Status" => 2,
                    "HtlCampBooking_Remark" => ""
                ],
                'headers' => $headers
            ]
        );
    }

    private function checkAllBookingTours($dateStart, $dateEnd)
    {
        $bookingTours = DB::select(
            'SELECT `bt`.*
            FROM `t_booking_tour` `bt`
            INNER JOIN `t_tour` `t` ON `t`.`Id_Tour` = `bt`.`Id_Tour`
            WHERE `BookingTour_DateStart` BETWEEN ? AND ?',
            [$dateStart, $dateEnd]
        );
        $modified = 0;

        foreach ($bookingTours as $bookingTour) {
            $tourHtlCamp = $this->getTourHtlCamp($bookingTour->Id_Tour);
            $htlCampBooking = DB::select(
                'SELECT `hcb`.*, `hcs`.*
                FROM `t_htl_camp_booking` `hcb`
                INNER JOIN `t_htl_camp_schedule` `hcs` ON `hcs`.`Id_HtlCampSchedule` = `hcb`.`Id_HtlCampSchedule`
                WHERE `Id_BookingTour` = ?
                AND `HtlCampBooking_Lock` = 2',
                [$bookingTour->Id_BookingTour]
            );
            $modified += $this->compareCamps($bookingTour, $tourHtlCamp, $htlCampBooking);
        }

        dd($bookingTours, $modified);
    }

    private function compareCamps($bookingTour, $tourHtlCampList, $htlCampBooking)
    {
        $modified = 0;
        foreach ($tourHtlCampList as $thc) {
            $expectedDate = date('Y-m-d', strtotime($bookingTour->BookingTour_DateStart . ' + ' . ($thc->TourHtlCamp_Day - 1) . ' day'));
            $found = null;
            foreach ($htlCampBooking as $hcb) {
                if ($thc->Id_HtlCamp == $hcb->Id_HtlCamp) {
                    $found = $hcb;
                }
            }
            if ($found) {
                $realDate = date('Y-m-d', strtotime($found->HtlCampSchedule_DateSchedule));
                if ($expectedDate != $realDate) {
                    $modified++;
                    $this->queryBus->ask(new UpdateHtlCampBookingQuery(
                        $found->Id_HtlCampBooking,
                        $expectedDate . ' 00:00:00',
                        $found->HtlCampBooking_Remark,
                        $found->HtlCampBooking_Status,
                    ));
                } else {
                    if ($found->HtlCampBooking_Amount != $found->HtlCampBooking_AmountTotal) {
                        $passengers = DB::select('SELECT `p`.`Id_Passenger` FROM `t_passenger` `p`
                            INNER JOIN `t_booking_tour_passenger` `btp` ON `btp`.`Id_Passenger` = `p`.`Id_Passenger`
                            WHERE `btp`.`Id_BookingTour` = ?', [$found->Id_BookingTour]);
                        foreach ($passengers as $index) {
                            $this->passengerUpdater->updateLockHtlCampBookingPassenger($index->Id_Passenger);
                        }
                    }
                }
            } else {
                /** @var CreateWithPassengersHtlCampBookingResponse $created */
                $created = $this->queryBus->ask(new CreateWithPassengersHtlCampBookingQuery(
                    $expectedDate . ' 00:00:00',
                    $thc->Id_HtlCamp,
                    $bookingTour->Id_BookingTour,
                    []
                ));
                $bookingTourPassengers = DB::select('SELECT `btp`.*
                    FROM `t_booking_tour_passenger` `btp` WHERE `Id_BookingTour`=?', [$bookingTour->Id_BookingTour]);
                array_map(function ($btp) use ($created) {
                    $this->bookingCreator->addHtlCampBookingPassenger(
                        $created->id(),
                        $btp->Id_BookingTourPassenger
                    );
                    $this->passengerUpdater->updateLockHtlCampBookingPassenger($btp->Id_Passenger);
                }, $bookingTourPassengers);
            }
        }

        foreach ($htlCampBooking as $hcb) {
            $found = false;
            foreach ($tourHtlCampList as $thc) {
                if ($hcb->Id_HtlCamp == $thc->Id_HtlCamp) {
                    $found = true;
                }
            }
            if (!$found) {
                DB::select('UPDATE `t_htl_camp_booking`
                    SET `HtlCampBooking_Status` = 0,
                        `HtlCampBooking_Amount` = 0,
                        `HtlCampBooking_AmountTotal` = 0
                    WHERE `Id_HtlCampBooking` = ?', [$hcb->Id_HtlCampBooking]);
                var_dump('Not found: ' . $hcb->Id_HtlCampBooking);
                $this->queryBus->ask(new ReloadAmountHtlCampScheduleQuery($hcb->Id_HtlCampSchedule));
            }
        }
        return $modified;
    }

    private function getNotEqualHtlCamp()
    {
        $availabilityCalendar = new AvailabilityCalendar();
        $campsCalendar = new CampsCalendar();
        $dateStart = '2021-01-01';
        $dateEnd = '2028-12-31';
        $list = $this->availabilityCalendar($dateStart, $dateEnd);

        foreach ($list as $ele) {
            $availabilityCalendar->setDate($ele->Calendar_DateCurrent, $ele, [
                'Calendar_Amount' => $ele->Calendar_Amount,
                'Tour_Code' => $ele->Tour_Code,
                'Found_Amount' => 0
            ]);
            $tourHtlCamp = $this->getTourHtlCamp($ele->Id_Tour);
            foreach ($tourHtlCamp as $htlCamp) {
                $date = date('Y-m-d', strtotime($ele->Calendar_DateCurrent . ' + ' . ($htlCamp->TourHtlCamp_Day - 1) . ' day'));

                $campsCalendar->setCalendar($htlCamp->Id_HtlCamp, $date, $ele, [
                    'Calendar_Amount' => $ele->Calendar_Amount,
                    'Tour_Code' => $ele->Tour_Code,
                    'Found_Amount' => 0
                ]);
            }
        }
        $this->getHtlCamp(1, $dateStart, $dateEnd);
        $this->getHtlCamp(3, $dateStart, $dateEnd);
        $this->getHtlCamp(2, $dateStart, $dateEnd);

        foreach ($this->htlCampSchedule as $Id_HtlCamp => $htlCampSchedule) {
            $camp = $campsCalendar->getHtlCamp($Id_HtlCamp);
            // dd($htlCampSchedule);
            if (!$camp) {
                continue;
            }
            foreach ($htlCampSchedule as $day) {
                $date = date('Y-m-d', strtotime($day->HtlCampSchedule_DateSchedule));
                $found = $camp->getDateTour($date, $day->Id_Tour);
                if ($found) {
                    $found['Found_Amount'] += $day->HtlCampBooking_Amount;
                    $camp->setDate($date, $day, $found);
                } else {
                    $camp->setDate($date, $day, [
                        'Calendar_Amount' => 0,
                        'Tour_Code' => $day->Tour_Code,
                        'Found_Amount' => $day->HtlCampBooking_Amount
                    ]);
                }
            }
        }

        $notEquals1 = $campsCalendar->getHtlCamp(1)->getDatesNotEquals();
        $notEquals2 = $campsCalendar->getHtlCamp(3)->getDatesNotEquals();
        $notEquals3 = $campsCalendar->getHtlCamp(2)->getDatesNotEquals();
        $count = count($notEquals1) + count($notEquals2) + count($notEquals3);

        dd($notEquals1, $notEquals2, $notEquals3, $count);
    }

    private function getHtlCamp($idHtlCamp, $dateStart, $dateEnd)
    {
        if (!isset($this->htlCampSchedule[$idHtlCamp])) {
            $this->htlCampSchedule[$idHtlCamp] = DB::select(
                'SELECT `hcs`.*, `hcb`.*, `bt`.*, `t`.*
                FROM `t_htl_camp_schedule` `hcs`
                INNER JOIN `t_htl_camp_booking` `hcb` ON `hcs`.`Id_HtlCampSchedule` = `hcb`.`Id_HtlCampSchedule`
                    AND `hcb`.`HtlCampBooking_Status` = 2
                INNER JOIN `t_booking_tour` `bt` ON `hcb`.`Id_BookingTour` = `bt`.`Id_BookingTour`
                INNER JOIN `t_tour` `t` ON `bt`.`Id_Tour` = `t`.`Id_Tour`
                WHERE `Id_HtlCamp`=?
                AND `HtlCampSchedule_DateSchedule` BETWEEN ? AND ?',
                [$idHtlCamp, $dateStart, $dateEnd]
            );
        }
    }

    private function getTourHtlCamp($idTour)
    {
        if (!isset($this->tourHtlCamp[$idTour])) {
            $this->tourHtlCamp[$idTour] = DB::select('SELECT * FROM t_tour_htl_camp WHERE `Id_Tour`=? AND `TourHtlCamp_Status` = 2', [$idTour]);
        }
        return $this->tourHtlCamp[$idTour];
    }

    private function availabilityCalendar($dateStart, $dateEnd)
    {
        return DB::select("SELECT
            COUNT(DISTINCT `btp`.`Id_BookingTourPassenger`) AS `Calendar_Amount`,
            `bt`.`BookingTour_DateStart` AS `Calendar_DateCurrent`,

            `t`.`Id_Tour`,
            `t`.`Tour_Name`,
            `t`.`Tour_Color`,
            `t`.`Tour_Code`,

            CONCAT(
                '[',
                GROUP_CONCAT(DISTINCT JSON_OBJECT(
                    'Id_Package', `pk`.`Id_Package`,
                    'Package_Name', `pk`.`Package_Name`,
                    'Package_Code', `pk`.`Package_Code`,
                    'Calendar_DateCurrent', `bt`.`BookingTour_DateStart`,
                    'Id_BookingTourPassenger', `btp`.`Id_BookingTourPassenger`
                ) SEPARATOR ','),
                ']'
            ) AS `Package_List`,

            COUNT(`g`.`Id_Group`) AS `Group_Count`,
            CONCAT(
                '[',
                GROUP_CONCAT(DISTINCT JSON_OBJECT(
                    'Id_BookingTourPassenger', `btp`.`Id_BookingTourPassenger`,
                    'WithGroup', IF(`g`.`Id_Group`, 'YES', 'NO')
                )),
                ']'
            ) AS `Group_List`

    FROM    `t_booking_tour`                AS `bt` INNER JOIN
            `t_booking`                     AS `b` ON `b`.`Id_Booking` = `bt`.`Id_Booking` INNER JOIN
            `t_booking_tour_passenger`      AS `btp` ON `btp`.`Id_BookingTour` = `bt`.`Id_BookingTour` INNER JOIN
            `t_passenger`                   AS `p` ON `p`.`Id_Passenger` =`btp`.`Id_Passenger` INNER JOIN
            `t_tour`                        AS `t` ON `t`.`Id_Tour` = `bt`. `Id_Tour` INNER JOIN
            `t_package`                     AS `pk` ON `pk`.`Id_Package` = `bt`.`Id_Package` LEFT JOIN
            `t_group_passenger`             AS `gp` ON `gp`.`Id` = `btp`.`Id_BookingTourPassenger` AND `gp`.`GroupPassenger_Type` = 1 LEFT JOIN
            `t_group`                       AS `g` ON `g`.`Id_Group` = `gp`.`Id_Group`

    WHERE   `bt`.`BookingTour_DateStart` BETWEEN ? AND ? AND
            `btp`.`BookingTourPassenger_Status` IN (2, 3)
            AND `bt`.`BookingTour_Status` = 2
            AND
            `fn_booking_tour_passenger_check`(
                `b`.`Booking_Status`,
                `b`.`Booking_ManuallyConfirmed`,
                `p`.`Passenger_InfoStatus`,
                `p`.`Passenger_PaymentStatus`,
                `btp`.`BookingTourPassenger_PaymentStatus`
            )
    GROUP BY `bt`.`BookingTour_DateStart`, `bt`.`Id_Tour`
    ORDER BY `bt`.`BookingTour_DateStart` ASC", [$dateStart, $dateEnd]);
    }
}
