<?php
namespace App\Http\Controllers\Owner\HtlTypeRoom;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\HtlTypeRoom\Application\HtlTypeRoomResponses;
use App\Modules\HtlTypeRoom\Application\List\HtlTypeRoomListerQuery;
use App\Modules\HtlTypeRoom\Application\List\ListHtlTypeRoomQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Transaction;

class HtlTypeRoomListController extends Controller
{
    private $domain;

    public function __construct(
        private QueryBus $queryBus,
        private Transaction $transaction
    ) {
        $this->domain = "HtlTypeRoom";
    }

    public function __invoke($Id_HtlCamp, $Action)
    {
        $this->transaction->begin();
        /** @var HtlTypeRoomResponses $response */
        $response = $this->queryBus->ask(new ListHtlTypeRoomQuery($Id_HtlCamp, $Action));
        $this->transaction->commit();

        return ResponseBuilder::Response([
            "Response_Status"           => 200,
            "Response_Code"             => 200,
            "Response_Data"             => $response->data(),
            "Response_Domain"           => $this->domain,
            "Response_Message"          => 'Listado con éxito',
            "Response_Error_Message"    => '',
            "Response_Error_Reason"     => '',
        ]);
    }
}
