<?php

namespace App\Http\Controllers\Owner\HtlTypeRoom;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\HtlTypeRoom\Application\Create\CreateHtlTypeRoomQuery;
use App\Modules\HtlTypeRoom\Application\Create\CreateHtlTypeRoomResponse;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\HtlTypeRoom\Infrastructure\HtlTypeRoomValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Transaction;

class HtlTypeRoomInsertController extends Controller
{
    private $domain;
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus,
        private Transaction $transaction
    ) {
        $this->domain = "HtlTypeRoom";
        $this->history = new HistoryData(HistoryTables::HTL_TYPE_ROOM);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, HtlTypeRoomValidators::INSERT);
        $this->transaction->begin();
        /** @var CreateHtlTypeRoomResponse $response */
        $response = $this->queryBus->ask(new CreateHtlTypeRoomQuery(
            $request->input('HtlTypeRoom_Name'),
            $request->input('HtlTypeRoom_Abrv'),
            $request->input('HtlTypeRoom_Status'),
            $request->input('Id_HtlCamp'),
        ));
        $this->transaction->commit();
        $this->history->insertBasic($request, $response->id());
        return ResponseBuilder::Response([
            "Response_Status"           => 200,
            "Response_Code"             => 200,
            "Response_Data"             => ['id' => $response->id()],
            "Response_Domain"           => $this->domain,
            "Response_Message"          => 'Tipo de Habitación agregado con éxito',
            "Response_Error_Message"    => '',
            "Response_Error_Reason"     => '',
        ]);
    }
}
