<?php

namespace App\Http\Controllers\Owner\HtlCampBookingPassenger;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\HtlCampBookingPassenger\Application\List\ListHtlCampBookingPassengerQuery;
use App\Modules\HtlCampBookingPassenger\Application\ListHtlCampBookingPassengerResponses;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Transaction;
use Illuminate\Http\Request;

class HtlCampBookingPassengerListController extends Controller
{
    private $domain;

    public function __construct(
        private QueryBus $queryBus,
        private Transaction $transaction
    ) {
        $this->domain = "HtlCampBookingPassenger";
    }

    public function __invoke(Request $request, $Id_HtlCampBooking, $Action)
    {
        $this->transaction->begin();
        /** @var ListHtlCampBookingPassengerResponses $response */
        $response = $this->queryBus->ask(new ListHtlCampBookingPassengerQuery($Id_HtlCampBooking, $Action));
        $this->transaction->commit();

        return ResponseBuilder::Response([
            "Response_Status"           => 200,
            "Response_Code"             => 200,
            "Response_Data"             => $response->data(),
            "Response_Domain"           => $this->domain,
            "Response_Message"          => 'Listado con éxito',
            "Response_Error_Message"    => '',
            "Response_Error_Reason"     => '',
        ]);
    }
}
