<?php

namespace App\Http\Controllers\Owner\HtlCampBookingPassenger;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Owner\c_Passenger;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\HtlCampBookingPassenger\Application\ListByHtlCampSchedule\ListByHtlCampScheduleHtlCampBookingPassengerQuery;
use App\Modules\HtlCampBookingPassenger\Application\ListByHtlCampSchedule\ListByHtlCampScheduleHtlCampBookingPassengerResponses;
use App\Modules\HtlCampBookingPassenger\Infrastructure\HtlCampBookingPassengerValidators;
use App\Modules\HtlCampSchedule\Application\Find\FindHtlCampScheduleQuery;
use App\Modules\HtlCampSchedule\Application\HtlCampScheduleResponse;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Transaction;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use Illuminate\Http\Request;

class HtlCampBookingPassengerListByScheduleController extends Controller
{
    private $domain;

    public function __construct(
        private QueryBus $queryBus,
        private Transaction $transaction
    ) {
        $this->domain = "HtlCampBookingPassenger";
    }

    public function __invoke(Request $request, $Action)
    {
        (new LaravelValidator())->validate(
            $request->all(),
            $this->domain,
            HtlCampBookingPassengerValidators::LIST_BY_SCHEDULE
        );

        $this->transaction->begin();
        /** @var HtlCampScheduleResponse $findResponse */
        $findResponse = $this->queryBus->ask(new FindHtlCampScheduleQuery(
            $request->input('Id_HtlCamp'),
            $request->input('Date') . ' 00:00:00'
        ));
        /** @var ListByHtlCampScheduleHtlCampBookingPassengerResponses $response */
        $response = $this->queryBus->ask(new ListByHtlCampScheduleHtlCampBookingPassengerQuery(
            $findResponse->Id_HtlCampSchedule,
            $Action
        ));
        $this->transaction->commit();

        return ResponseBuilder::Response([
            "Response_Status"           => 200,
            "Response_Code"             => 200,
            "Response_Data"             => $this->convertFunction($response->data()),
            "Response_Domain"           => $this->domain,
            "Response_Message"          => 'Listado con éxito',
            "Response_Error_Message"    => '',
            "Response_Error_Reason"     => '',
        ]);
    }

    public function convertFunction($passengers)
    {
        return array_map(function ($pass) {
            $pass->Passenger_ImgDocument1_Path = c_Passenger::path1_large() . $pass->Passenger_ImgDocument1;
            $pass->Passenger_ImgDocument1_Thumb = c_Passenger::path1_thumb() . $pass->Passenger_ImgDocument1;
            $pass->UserCountry_Img_Path = config('var.PATH_PUBLIC') . config('var.USER_COUNTRY_THUMB') . $pass->UserCountry_Img;
            $pass->Admin_ImgProfile_Thumb = config('var.PATH_PUBLIC') . $pass->Admin_ImgProfile_Thumb;
            return $pass;
        }, $passengers);
    }
}
