<?php

namespace App\Http\Controllers\Owner\HtlBed;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\HtlBed\Application\Update\UpdateHtlBedQuery;
use App\Modules\HtlBed\Infrastructure\HtlBedValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Transaction;

class HtlBedUpdateController extends Controller
{
    private $domain;
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus,
        private Transaction $transaction
    ) {
        $this->domain = "HtlBed";
        $this->history = new HistoryData(HistoryTables::HTL_BED);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, HtlBedValidators::UPDATE);
        $this->transaction->begin();
        $this->history->obtainOld($request->input('Id_HtlBed'));
        $this->queryBus->ask(new UpdateHtlBedQuery(
            $request->input('Id_HtlBed'),
            $request->input('HtlBed_Name'),
            $request->input('HtlBed_Description'),
            $request->input('HtlBed_Availability'),
            $request->input('HtlBed_Status'),
        ));
        $this->history->updateBasic($request->input('Id_HtlBed'), $request);
        $this->transaction->commit();
        return ResponseBuilder::Response([
            "Response_Status"           => 200,
            "Response_Code"             => 200,
            "Response_Data"             => [],
            "Response_Domain"           => $this->domain,
            "Response_Message"          => 'Cama modificada con éxito',
            "Response_Error_Message"    => '',
            "Response_Error_Reason"     => '',
        ]);
    }
}
