<?php

namespace App\Http\Controllers\Owner\HtlBed;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\HtlBed\Application\Create\CreateHtlBedQuery;
use App\Modules\HtlBed\Application\Create\CreateHtlBedResponse;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\HtlBed\Infrastructure\HtlBedValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Transaction;

class HtlBedInsertController extends Controller
{
    private $domain;
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus,
        private Transaction $transaction
    ) {
        $this->domain = "HtlBed";
        $this->history = new HistoryData(HistoryTables::HTL_BED);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, HtlBedValidators::INSERT);
        $this->transaction->begin();
        /** @var CreateHtlBedResponse $response */
        $response = $this->queryBus->ask(new CreateHtlBedQuery(
            $request->input('HtlBed_Name'),
            $request->input('HtlBed_Description'),
            $request->input('HtlBed_Availability'),
            $request->input('HtlBed_Status'),
            $request->input('Id_HtlCamp'),
        ));
        $this->history->insertBasic($request, $response->id());
        $this->transaction->commit();
        return ResponseBuilder::Response([
            "Response_Status"           => 200,
            "Response_Code"             => 200,
            "Response_Data"             => ['id' => $response->id()],
            "Response_Domain"           => $this->domain,
            "Response_Message"          => 'Cama agregada con éxito',
            "Response_Error_Message"    => '',
            "Response_Error_Reason"     => '',
        ]);
    }
}
