<?php

namespace App\Http\Controllers\Owner\GroupProviderReview;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\GroupProviderReview\Application\GroupProviderReviewFinder;
use App\Modules\GroupProviderReview\Infraestructure\GroupProviderReviewValidators;
use App\Modules\GroupProviderReview\Infraestructure\MysqlGroupProviderReviewRepository;
use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;

class GroupProviderReviewListController extends Controller
{
    private $domain;

    public function __construct()
    {
        $this->domain = "GroupProviderReview";
    }

    public function __invoke($Action, Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, GroupProviderReviewValidators::FIND);

        $oResponse = (new GroupProviderReviewFinder(new MysqlGroupProviderReviewRepository))
            ->__invoke(
                $Action,
                new DateStart($request->input('DateStart')),
                new DateEnd($request->input('DateEnd'))
            );
        return ResponseBuilder::Response($oResponse);
    }
}
