<?php
namespace App\Http\Controllers\Owner\GroupProviderReview;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\GroupProviderReview\Application\GroupProviderReviewDeleter;
use App\Modules\GroupProviderReview\Domain\IdGroupProviderReview;
use App\Modules\GroupProviderReview\Infraestructure\MysqlGroupProviderReviewRepository;

class GroupProviderReviewDeleteController extends Controller
{
    /** @var HistoryData */
    private $history;

    public function __construct()
    {
        $this->history = new HistoryData(HistoryTables::GROUP_PROVIDER_REVIEW);
    }

    public function __invoke(Request $Request, int $Id)
    {
        $this->history->obtainOld($Id);

        $response = (new GroupProviderReviewDeleter(new MysqlGroupProviderReviewRepository()))
            ->__invoke(new IdGroupProviderReview($Id));

        $this->history->deleteBasic($Id, $Request);

        return ResponseBuilder::Response($response);
    }
}
